/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.DoubleArray;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.NumericDoubleValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.Bits;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.InternalMin;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;

class MinAggregator
extends NumericMetricsAggregator.SingleValue {
    private static final int MAX_BKD_LOOKUPS = 1024;
    final NumericValuesSource valuesSource;
    final DocValueFormat format;
    final String pointField;
    final Function<byte[], Number> pointConverter;
    DoubleArray mins;

    MinAggregator(String name, ValuesSourceConfig config, SearchExecutionContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        NumericValuesSource numericValuesSource = this.valuesSource = config.hasValues() ? (NumericValuesSource)config.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.mins = context.bigArrays().newDoubleArray(1L, false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
        }
        this.format = config.format();
        this.pointConverter = this.pointReaderIfAvailable(config);
        this.pointField = this.pointConverter != null ? config.fieldContext().field() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        Number segMin;
        if (this.valuesSource == null) {
            if (this.parent == null) {
                return LeafBucketCollector.NO_OP_COLLECTOR;
            }
            throw new CollectionTerminatedException();
        }
        if (this.pointConverter != null && (segMin = MinAggregator.findLeafMinValue(ctx.reader(), this.pointField, this.pointConverter)) != null) {
            double min = this.mins.get(0L);
            min = Math.min(min, segMin.doubleValue());
            this.mins.set(0L, min);
            throw new CollectionTerminatedException();
        }
        final BigArrays bigArrays = this.context.bigArrays();
        SortedNumericDoubleValues allValues = this.valuesSource.doubleValues(ctx);
        final NumericDoubleValues values = MultiValueMode.MIN.select(allValues);
        return new LeafBucketCollectorBase(sub, allValues){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= MinAggregator.this.mins.size()) {
                    long from = MinAggregator.this.mins.size();
                    MinAggregator.this.mins = bigArrays.grow(MinAggregator.this.mins, bucket + 1L);
                    MinAggregator.this.mins.fill(from, MinAggregator.this.mins.size(), Double.POSITIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    double value = values.doubleValue();
                    double min = MinAggregator.this.mins.get(bucket);
                    min = Math.min(min, value);
                    MinAggregator.this.mins.set(bucket, min);
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.mins.size()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mins.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.mins.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalMin(this.name, this.mins.get(bucket), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalMin(this.name, Double.POSITIVE_INFINITY, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.mins);
    }

    static Number findLeafMinValue(LeafReader reader, String fieldName, final Function<byte[], Number> converter) throws IOException {
        PointValues pointValues = reader.getPointValues(fieldName);
        if (pointValues == null) {
            return null;
        }
        final Bits liveDocs = reader.getLiveDocs();
        if (liveDocs == null) {
            return converter.apply(pointValues.getMinPackedValue());
        }
        final Number[] result = new Number[1];
        try {
            pointValues.intersect(new PointValues.IntersectVisitor(){
                private short lookupCounter = 0;

                public void visit(int docID) {
                    throw new UnsupportedOperationException();
                }

                public void visit(int docID, byte[] packedValue) {
                    if (liveDocs.get(docID)) {
                        result[0] = (Number)converter.apply(packedValue);
                        throw new CollectionTerminatedException();
                    }
                    this.lookupCounter = (short)(this.lookupCounter + 1);
                    if (this.lookupCounter > 1024) {
                        throw new CollectionTerminatedException();
                    }
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
            });
        }
        catch (CollectionTerminatedException collectionTerminatedException) {
            // empty catch block
        }
        return result[0];
    }
}

