/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import org.opensearch.search.aggregations.ParsedAggregation;
import org.opensearch.search.aggregations.metrics.ValueCount;

public class ParsedValueCount
extends ParsedAggregation
implements ValueCount {
    private long valueCount;
    private static final ObjectParser<ParsedValueCount, Void> PARSER = new ObjectParser(ParsedValueCount.class.getSimpleName(), true, ParsedValueCount::new);

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public long getValue() {
        return this.valueCount;
    }

    @Override
    public String getValueAsString() {
        return Double.toString(this.valueCount);
    }

    public String getType() {
        return "value_count";
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.valueCount);
        return builder;
    }

    public static ParsedValueCount fromXContent(XContentParser parser, String name) {
        ParsedValueCount sum = (ParsedValueCount)PARSER.apply(parser, null);
        sum.setName(name);
        return sum;
    }

    static {
        ParsedValueCount.declareAggregationFields(PARSER);
        PARSER.declareLong((agg, value) -> {
            agg.valueCount = value;
        }, Aggregation.CommonFields.VALUE);
    }
}

