/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.metrics.AbstractPercentilesAggregationBuilder;
import org.opensearch.search.aggregations.metrics.InternalHDRPercentiles;
import org.opensearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.opensearch.search.aggregations.metrics.PercentilesAggregatorFactory;
import org.opensearch.search.aggregations.metrics.PercentilesAggregatorSupplier;
import org.opensearch.search.aggregations.metrics.PercentilesConfig;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class PercentilesAggregationBuilder
extends AbstractPercentilesAggregationBuilder<PercentilesAggregationBuilder> {
    public static final String NAME = "percentiles";
    public static final AggregationRegistry.RegistryKey<PercentilesAggregatorSupplier> REGISTRY_KEY = new AggregationRegistry.RegistryKey("percentiles", PercentilesAggregatorSupplier.class);
    private static final double[] DEFAULT_PERCENTS = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};
    private static final ParseField PERCENTS_FIELD = new ParseField("percents", new String[0]);
    private static final ConstructingObjectParser<PercentilesAggregationBuilder, String> PARSER = AbstractPercentilesAggregationBuilder.createParser("percentiles", (name, values, percentileConfig) -> {
        values = values == null ? DEFAULT_PERCENTS : PercentilesAggregationBuilder.validatePercentiles(values, name);
        return new PercentilesAggregationBuilder((String)name, (double[])values, (PercentilesConfig)percentileConfig);
    }, PercentilesConfig.TDigest::new, PERCENTS_FIELD);

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        PercentilesAggregatorFactory.registerAggregators(builder);
    }

    public PercentilesAggregationBuilder(StreamInput in) throws IOException {
        super(in, PERCENTS_FIELD);
    }

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return (AggregationBuilder)PARSER.parse(parser, (Object)aggregationName);
    }

    public PercentilesAggregationBuilder(String name) {
        this(name, DEFAULT_PERCENTS, null);
    }

    public PercentilesAggregationBuilder(String name, double[] values, PercentilesConfig percentilesConfig) {
        super(name, values, percentilesConfig, PERCENTS_FIELD);
    }

    protected PercentilesAggregationBuilder(PercentilesAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new PercentilesAggregationBuilder(this, factoriesBuilder, metadata);
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    public PercentilesAggregationBuilder percentiles(double ... percents) {
        this.values = PercentilesAggregationBuilder.validatePercentiles(percents, this.name);
        return this;
    }

    private static double[] validatePercentiles(double[] percents, String aggName) {
        if (percents == null) {
            throw new IllegalArgumentException("[percents] must not be null: [" + aggName + "]");
        }
        if (percents.length == 0) {
            throw new IllegalArgumentException("[percents] must not be empty: [" + aggName + "]");
        }
        double[] sortedPercents = Arrays.copyOf(percents, percents.length);
        Arrays.sort(sortedPercents);
        for (double percent : sortedPercents) {
            if (!(percent < 0.0) && !(percent > 100.0)) continue;
            throw new IllegalArgumentException("percent must be in [0,100], got [" + percent + "]: [" + aggName + "]");
        }
        return sortedPercents;
    }

    public double[] percentiles() {
        return this.values;
    }

    @Override
    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new PercentilesAggregatorFactory(this.name, config, this.values, this.configOrDefault(), this.keyed, context, parent, subFactoriesBuilder, this.metadata);
    }

    public String getType() {
        return NAME;
    }

    @Override
    protected AggregationRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.METRIC;
        }

        public String getName() {
            return PercentilesAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return PercentilesAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Arrays.asList(new Tuple(Optional.of("tdigest_percentiles"), InternalTDigestPercentiles::new), new Tuple(Optional.of("hdr_percentiles"), InternalHDRPercentiles::new));
        }

        public ContextParser<String, PercentilesAggregationBuilder> getParser() {
            return PARSER;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return PercentilesAggregationBuilder::registerAggregators;
        }
    }
}

