/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.io.stream.spi.StreamableProvider;
import java.io.IOException;

public class ScriptedAvg
implements Writeable {
    private final double sum;
    private final long count;

    public ScriptedAvg(double sum, long count) {
        this.sum = sum;
        this.count = count;
    }

    public ScriptedAvg(StreamInput in) throws IOException {
        this.sum = in.readDouble();
        this.count = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.sum);
        out.writeLong(this.count);
    }

    public double getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public double getValue() {
        return this.count > 0L ? this.sum / (double)this.count : 0.0;
    }

    public static final class StreamableProviderImpl
    implements StreamableProvider {
        public byte getLegacyUniqueByte() {
            return 28;
        }

        public Class<?> getTypeClass() {
            return ScriptedAvg.class;
        }

        public Writeable.Writer<?> getWriter() {
            return (o, v) -> {
                o.writeByte((byte)28);
                ((ScriptedAvg)v).writeTo(o);
            };
        }

        public Writeable.Reader<?> getReader() {
            return ScriptedAvg::new;
        }
    }
}

