/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.Nullable;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.script.Script;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.script.ScriptedMetricAggContexts;
import org.opensearch.search.SearchParseException;
import org.opensearch.search.aggregations.metrics.ScriptedMetricAggregator;

class ScriptedMetricAggregatorFactory
extends AggregatorFactory {
    private final ScriptedMetricAggContexts.MapScript.Factory mapScript;
    private final Map<String, Object> mapScriptParams;
    private final ScriptedMetricAggContexts.CombineScript.Factory combineScript;
    private final Map<String, Object> combineScriptParams;
    private final Script reduceScript;
    private final Map<String, Object> aggParams;
    @Nullable
    private final ScriptedMetricAggContexts.InitScript.Factory initScript;
    private final Map<String, Object> initScriptParams;

    ScriptedMetricAggregatorFactory(String name, ScriptedMetricAggContexts.MapScript.Factory mapScript, Map<String, Object> mapScriptParams, @Nullable ScriptedMetricAggContexts.InitScript.Factory initScript, Map<String, Object> initScriptParams, ScriptedMetricAggContexts.CombineScript.Factory combineScript, Map<String, Object> combineScriptParams, Script reduceScript, Map<String, Object> aggParams, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
        this.mapScript = mapScript;
        this.mapScriptParams = mapScriptParams;
        this.initScript = initScript;
        this.initScriptParams = initScriptParams;
        this.combineScript = combineScript;
        this.combineScriptParams = combineScriptParams;
        this.reduceScript = reduceScript;
        this.aggParams = aggParams;
    }

    public Aggregator createInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        Map<String, Object> aggParams = this.aggParams == null ? Map.of() : this.aggParams;
        Script reduceScript = ScriptedMetricAggregatorFactory.deepCopyScript(this.reduceScript, searchContext, aggParams);
        return new ScriptedMetricAggregator(this.name, this.context.lookup(), aggParams, this.initScript, this.initScriptParams, this.mapScript, this.mapScriptParams, this.combineScript, this.combineScriptParams, reduceScript, searchContext, parent, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }

    private static Script deepCopyScript(Script script, SearchExecutionContext context, Map<String, Object> aggParams) {
        if (script != null) {
            Map<String, Object> params = ScriptedMetricAggregatorFactory.mergeParams(aggParams, ScriptedMetricAggregatorFactory.deepCopyParams(script.getParams(), context));
            return new Script(script.getType(), script.getLang(), script.getIdOrCode(), params);
        }
        return null;
    }

    static <T> T deepCopyParams(T original, SearchExecutionContext context) {
        Object clone;
        if (original instanceof Map) {
            Map originalMap = (Map)original;
            HashMap clonedMap = new HashMap();
            for (Map.Entry e : originalMap.entrySet()) {
                clonedMap.put(ScriptedMetricAggregatorFactory.deepCopyParams(e.getKey(), context), ScriptedMetricAggregatorFactory.deepCopyParams(e.getValue(), context));
            }
            clone = clonedMap;
        } else if (original instanceof List) {
            List originalList = (List)original;
            ArrayList clonedList = new ArrayList();
            for (Object o : originalList) {
                clonedList.add(ScriptedMetricAggregatorFactory.deepCopyParams(o, context));
            }
            clone = clonedList;
        } else if (original instanceof String || original instanceof Integer || original instanceof Long || original instanceof Short || original instanceof Byte || original instanceof Float || original instanceof Double || original instanceof Character || original instanceof Boolean) {
            clone = original;
        } else {
            throw new SearchParseException(context.shardTarget(), "Can only clone primitives, String, ArrayList, and HashMap. Found: " + original.getClass().getCanonicalName(), null);
        }
        return clone;
    }

    static Map<String, Object> mergeParams(Map<String, Object> agg, Map<String, Object> script) {
        HashMap<String, Object> combined = new HashMap<String, Object>(script);
        for (Map.Entry<String, Object> aggEntry : agg.entrySet()) {
            if (combined.putIfAbsent(aggEntry.getKey(), aggEntry.getValue()) == null) continue;
            throw new IllegalArgumentException("Parameter name \"" + aggEntry.getKey() + "\" used in both aggregation and script parameters");
        }
        return combined;
    }
}

