/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.DoubleArray;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.CompensatedSum;
import org.opensearch.search.aggregations.metrics.InternalSum;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;

public class SumAggregator
extends NumericMetricsAggregator.SingleValue {
    private final NumericValuesSource valuesSource;
    private final DocValueFormat format;
    private DoubleArray sums;
    private DoubleArray compensations;

    SumAggregator(String name, ValuesSourceConfig valuesSourceConfig, SearchExecutionContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? (NumericValuesSource)valuesSourceConfig.getValuesSource() : null;
        this.format = valuesSourceConfig.format();
        if (this.valuesSource != null) {
            this.sums = context.bigArrays().newDoubleArray(1L, true);
            this.compensations = context.bigArrays().newDoubleArray(1L, true);
        }
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                SumAggregator.this.sums = bigArrays.grow(SumAggregator.this.sums, bucket + 1L);
                SumAggregator.this.compensations = bigArrays.grow(SumAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    double sum = SumAggregator.this.sums.get(bucket);
                    double compensation = SumAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        kahanSummation.add(value);
                    }
                    SumAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    SumAggregator.this.sums.set(bucket, kahanSummation.value());
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalSum(this.name, this.sums.get(bucket), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalSum(this.name, 0.0, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sums, this.compensations});
    }
}

