/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.opensearch.search.aggregations.metrics.AbstractTDigestPercentilesAggregator;
import org.opensearch.search.aggregations.metrics.InternalTDigestPercentileRanks;
import org.opensearch.search.aggregations.metrics.TDigestState;

class TDigestPercentileRanksAggregator
extends AbstractTDigestPercentilesAggregator {
    TDigestPercentileRanksAggregator(String name, ValuesSource valuesSource, SearchExecutionContext context, Aggregator parent, double[] percents, double compression, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, valuesSource, context, parent, percents, compression, keyed, formatter, metadata);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TDigestState state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalTDigestPercentileRanks(this.name, this.keys, state, this.keyed, this.formatter, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalTDigestPercentileRanks(this.name, this.keys, new TDigestState(this.compression), this.keyed, this.formatter, this.metadata());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        TDigestState state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return InternalTDigestPercentileRanks.percentileRank(state, Double.valueOf(name));
    }
}

