/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.search.fetch.StoredFieldsContext;
import io.skylite.core.search.fetch.subphase.FetchDocValuesContext;
import io.skylite.core.search.fetch.subphase.FetchFieldsContext;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.search.fetch.subphase.FieldAndFormat;
import io.skylite.core.search.fetch.subphase.ScriptFieldsContext;
import io.skylite.core.search.fetch.subphase.highlight.HighlightBuilder;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.sort.SortAndFormats;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.search.aggregations.metrics.TopHitsAggregator;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.internal.SubSearchContext;

class TopHitsAggregatorFactory
extends AggregatorFactory {
    private final int from;
    private final int size;
    private final boolean explain;
    private final boolean version;
    private final boolean seqNoAndPrimaryTerm;
    private final boolean trackScores;
    private final Optional<SortAndFormats> sort;
    private final HighlightBuilder highlightBuilder;
    private final StoredFieldsContext storedFieldsContext;
    private final List<FieldAndFormat> docValueFields;
    private final List<FieldAndFormat> fetchFields;
    private final List<ScriptFieldsContext.ScriptField> scriptFields;
    private final FetchSourceContext fetchSourceContext;

    TopHitsAggregatorFactory(String name, int from, int size, boolean explain, boolean version, boolean seqNoAndPrimaryTerm, boolean trackScores, Optional<SortAndFormats> sort, HighlightBuilder highlightBuilder, StoredFieldsContext storedFieldsContext, List<FieldAndFormat> docValueFields, List<FieldAndFormat> fetchFields, List<ScriptFieldsContext.ScriptField> scriptFields, FetchSourceContext fetchSourceContext, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
        this.from = from;
        this.size = size;
        this.explain = explain;
        this.version = version;
        this.seqNoAndPrimaryTerm = seqNoAndPrimaryTerm;
        this.trackScores = trackScores;
        this.sort = sort;
        this.highlightBuilder = highlightBuilder;
        this.storedFieldsContext = storedFieldsContext;
        this.docValueFields = docValueFields;
        this.fetchFields = fetchFields;
        this.scriptFields = scriptFields;
        this.fetchSourceContext = fetchSourceContext;
    }

    public Aggregator createInternal(SearchExecutionContext searchExecutionContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        SearchContext searchContext = (SearchContext)searchExecutionContext;
        SubSearchContext subSearchContext = new SubSearchContext(searchContext);
        subSearchContext.parsedQuery(searchContext.parsedQuery());
        subSearchContext.explain(this.explain);
        subSearchContext.version(this.version);
        subSearchContext.seqNoAndPrimaryTerm(this.seqNoAndPrimaryTerm);
        subSearchContext.trackScores(this.trackScores);
        subSearchContext.from(this.from);
        subSearchContext.size(this.size);
        if (this.sort.isPresent()) {
            subSearchContext.sort(this.sort.get());
        }
        if (this.storedFieldsContext != null) {
            subSearchContext.storedFieldsContext(this.storedFieldsContext);
        }
        if (this.docValueFields != null) {
            FetchDocValuesContext docValuesContext = FetchDocValuesContext.create(arg_0 -> ((MapperService)searchContext.mapperService()).simpleMatchToFullName(arg_0), (int)searchContext.mapperService().getIndexSettings().getMaxDocvalueFields(), this.docValueFields);
            subSearchContext.docValuesContext(docValuesContext);
        }
        if (this.fetchFields != null) {
            FetchFieldsContext fieldsContext = new FetchFieldsContext(this.fetchFields);
            subSearchContext.fetchFieldsContext(fieldsContext);
        }
        for (ScriptFieldsContext.ScriptField field : this.scriptFields) {
            subSearchContext.scriptFields().add(field);
        }
        if (this.fetchSourceContext != null) {
            subSearchContext.fetchSourceContext(this.fetchSourceContext);
        }
        if (this.highlightBuilder != null) {
            subSearchContext.highlight(this.highlightBuilder.build(searchContext.getQueryShardContext()));
        }
        return new TopHitsAggregator(searchContext.fetchPhase(), subSearchContext, this.name, searchContext, parent, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

