/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.Aggregations;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.bucket.MultiBucketsAggregation;
import io.skylite.core.aggregations.pipeline.SiblingPipelineAggregator;
import io.skylite.core.aggregations.support.AggregationPath;
import io.skylite.core.index.fielddata.DocValueFormat;
import java.util.List;
import java.util.Map;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;

public abstract class BucketMetricsPipelineAggregator
extends SiblingPipelineAggregator {
    protected final DocValueFormat format;
    protected final BucketHelpers.GapPolicy gapPolicy;

    BucketMetricsPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat format, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.gapPolicy = gapPolicy;
        this.format = format;
    }

    public final InternalAggregation doReduce(Aggregations aggregations, InternalAggregation.ReduceContext context) {
        this.preCollection();
        List bucketsPath = AggregationPath.parse((String)this.bucketsPaths()[0]).getPathElementsAsStringList();
        for (Aggregation aggregation : aggregations) {
            if (!aggregation.getName().equals(bucketsPath.get(0))) continue;
            List<String> sublistedPath = bucketsPath.subList(1, bucketsPath.size());
            InternalMultiBucketAggregation multiBucketsAgg = (InternalMultiBucketAggregation)aggregation;
            List buckets = multiBucketsAgg.getBuckets();
            for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
                Double bucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)multiBucketsAgg, bucket, sublistedPath, this.gapPolicy);
                if (bucketValue == null || Double.isNaN(bucketValue)) continue;
                this.collectBucketValue(bucket.getKeyAsString(), bucketValue);
            }
        }
        return this.buildAggregation(this.metadata());
    }

    protected void preCollection() {
    }

    protected abstract InternalAggregation buildAggregation(Map<String, Object> var1);

    protected abstract void collectBucketValue(String var1, Double var2);
}

