/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.pipeline;

import io.skylite.common.Nullable;
import io.skylite.common.collect.EvictingQueue;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.InternalAggregations;
import io.skylite.core.aggregations.bucket.MultiBucketsAggregation;
import io.skylite.core.aggregations.pipeline.PipelineAggregator;
import io.skylite.core.index.fielddata.DocValueFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.InternalSimpleValue;

public class SerialDiffPipelineAggregator
extends PipelineAggregator {
    private DocValueFormat formatter;
    private BucketHelpers.GapPolicy gapPolicy;
    private int lag;

    SerialDiffPipelineAggregator(String name, String[] bucketsPaths, @Nullable DocValueFormat formatter, BucketHelpers.GapPolicy gapPolicy, int lag, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
        this.lag = lag;
    }

    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation histo = (InternalMultiBucketAggregation)aggregation;
        List buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)((Object)histo);
        ArrayList<MultiBucketsAggregation.Bucket> newBuckets = new ArrayList<MultiBucketsAggregation.Bucket>();
        EvictingQueue lagWindow = new EvictingQueue(this.lag);
        int counter = 0;
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)histo, bucket, this.bucketsPaths()[0], this.gapPolicy);
            InternalMultiBucketAggregation.InternalBucket newBucket = bucket;
            Double lagValue = ++counter <= this.lag ? Double.valueOf(Double.NaN) : (Double)lagWindow.peek();
            if (thisBucketValue == null) {
                thisBucketValue = Double.NaN;
            }
            if (!Double.isNaN(thisBucketValue) && !Double.isNaN(lagValue)) {
                double diff = thisBucketValue - lagValue;
                List aggs = StreamSupport.stream(bucket.getAggregations().spliterator(), false).map(p -> (InternalAggregation)p).collect(Collectors.toList());
                aggs.add(new InternalSimpleValue(this.name(), diff, this.formatter, this.metadata()));
                newBucket = factory.createBucket(factory.getKey(bucket), bucket.getDocCount(), InternalAggregations.from(aggs));
            }
            newBuckets.add(newBucket);
            lagWindow.add((Object)thisBucketValue);
        }
        return factory.createAggregation(newBuckets);
    }
}

