/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;

public abstract class MultiValuesSource<VS extends ValuesSource> {
    protected Map<String, VS> values;

    public boolean needsScores() {
        return this.values.values().stream().anyMatch(ValuesSource::needsScores);
    }

    public boolean areValuesSourcesEmpty() {
        return this.values.values().stream().allMatch(Objects::isNull);
    }

    public static class NumericMultiValuesSource
    extends MultiValuesSource<NumericValuesSource> {
        public NumericMultiValuesSource(Map<String, ValuesSourceConfig> valuesSourceConfigs) {
            this.values = new HashMap(valuesSourceConfigs.size());
            for (Map.Entry<String, ValuesSourceConfig> entry : valuesSourceConfigs.entrySet()) {
                ValuesSource valuesSource = entry.getValue().getValuesSource();
                if (!(valuesSource instanceof NumericValuesSource)) {
                    throw new AggregationExecutionException("ValuesSource type " + valuesSource.toString() + "is not supported for multi-valued aggregation");
                }
                this.values.put(entry.getKey(), (NumericValuesSource)valuesSource);
            }
        }

        public SortedNumericDoubleValues getField(String fieldName, LeafReaderContext ctx) throws IOException {
            NumericValuesSource value = (NumericValuesSource)this.values.get(fieldName);
            if (value == null) {
                throw new IllegalArgumentException("Could not find field name [" + fieldName + "] in multiValuesSource");
            }
            return value.doubleValues(ctx);
        }
    }
}

