/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import io.skylite.common.Nullable;
import io.skylite.core.aggregations.AbstractAggregationBuilder;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationInitializationException;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.values.ValueType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.script.Script;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.opensearch.search.aggregations.support.ValueTypeRegistry;

public abstract class MultiValuesSourceAggregationBuilder<AB extends MultiValuesSourceAggregationBuilder<AB>>
extends AbstractAggregationBuilder<AB> {
    private Map<String, MultiValuesSourceFieldConfig> fields = new HashMap<String, MultiValuesSourceFieldConfig>();
    private ValueType userValueTypeHint = null;
    private String format = null;

    protected MultiValuesSourceAggregationBuilder(String name) {
        super(name);
    }

    protected MultiValuesSourceAggregationBuilder(MultiValuesSourceAggregationBuilder<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.fields = new HashMap<String, MultiValuesSourceFieldConfig>(clone.fields);
        this.userValueTypeHint = clone.userValueTypeHint;
        this.format = clone.format;
    }

    protected MultiValuesSourceAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.read(in);
    }

    private void read(StreamInput in) throws IOException {
        this.fields = in.readMap(StreamInput::readString, MultiValuesSourceFieldConfig::new);
        this.userValueTypeHint = (ValueType)in.readOptionalWriteable(ValueTypeRegistry::readFromStream);
        this.format = in.readOptionalString();
    }

    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeMap(this.fields, StreamOutput::writeString, (o, value) -> value.writeTo(o));
        out.writeOptionalWriteable((Writeable)this.userValueTypeHint);
        out.writeOptionalString(this.format);
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    protected AB field(String propertyName, MultiValuesSourceFieldConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("[config] must not be null: [" + this.name + "]");
        }
        this.fields.put(propertyName, config);
        return (AB)((Object)this);
    }

    public AB userValueTypeHint(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[userValueTypeHint] must not be null: [" + this.name + "]");
        }
        this.userValueTypeHint = valueType;
        return (AB)((Object)this);
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)((Object)this);
    }

    protected abstract ValuesSourceType defaultValueSourceType();

    protected final MultiValuesSourceAggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        HashMap<String, ValuesSourceConfig> configs = new HashMap<String, ValuesSourceConfig>(this.fields.size());
        HashMap<String, QueryBuilder> filters = new HashMap<String, QueryBuilder>(this.fields.size());
        this.fields.forEach((key, value) -> {
            ValuesSourceConfig config = ValuesSourceConfig.resolveUnregistered((AggregationContext)context, (ValueType)this.userValueTypeHint, (String)value.getFieldName(), (Script)value.getScript(), (Object)value.getMissing(), (ZoneId)value.getTimeZone(), (String)this.format, (ValuesSourceType)this.defaultValueSourceType());
            configs.put((String)key, config);
            filters.put((String)key, value.getFilter());
        });
        DocValueFormat docValueFormat = MultiValuesSourceAggregationBuilder.resolveFormat(this.format, this.userValueTypeHint, this.defaultValueSourceType());
        return this.innerBuild(context, configs, filters, docValueFormat, parent, subFactoriesBuilder);
    }

    private static DocValueFormat resolveFormat(@Nullable String format, @Nullable ValueType valueType, ValuesSourceType defaultValuesSourceType) {
        if (valueType == null) {
            return defaultValuesSourceType.getFormatter(format, null);
        }
        DocValueFormat valueFormat = valueType.defaultFormat();
        if (valueFormat instanceof DocValueFormat.Decimal && format != null) {
            valueFormat = new DocValueFormat.Decimal(format);
        }
        return valueFormat;
    }

    protected abstract MultiValuesSourceAggregatorFactory innerBuild(AggregationContext var1, Map<String, ValuesSourceConfig> var2, Map<String, QueryBuilder> var3, DocValueFormat var4, AggregatorFactory var5, AggregatorFactories.Builder var6) throws IOException;

    public final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.fields != null) {
            for (Map.Entry<String, MultiValuesSourceFieldConfig> fieldEntry : this.fields.entrySet()) {
                builder.field(fieldEntry.getKey(), (ToXContent)fieldEntry.getValue());
            }
        }
        if (this.format != null) {
            builder.field(AggregationBuilder.CommonFields.FORMAT.getPreferredName(), this.format);
        }
        if (this.userValueTypeHint != null) {
            builder.field(AggregationBuilder.CommonFields.VALUE_TYPE.getPreferredName(), this.userValueTypeHint.getPreferredName());
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields, this.format, this.userValueTypeHint);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MultiValuesSourceAggregationBuilder other = (MultiValuesSourceAggregationBuilder)((Object)obj);
        return Objects.equals(this.fields, other.fields) && Objects.equals(this.format, other.format) && Objects.equals(this.userValueTypeHint, other.userValueTypeHint);
    }

    public static abstract class LeafOnly<AB extends MultiValuesSourceAggregationBuilder<AB>>
    extends MultiValuesSourceAggregationBuilder<AB> {
        protected LeafOnly(String name) {
            super(name);
        }

        protected LeafOnly(LeafOnly<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            super(clone, factoriesBuilder, metadata);
            if (factoriesBuilder.count() > 0) {
                throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
            }
        }

        protected LeafOnly(StreamInput in) throws IOException {
            super(in);
        }

        public AB subAggregations(AggregatorFactories.Builder subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
        }
    }
}

