/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.settings;

import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.List;

public class NodeDuressSettings {
    private volatile int numSuccessiveBreaches;
    public static final Setting<Integer> SETTING_NUM_SUCCESSIVE_BREACHES = Setting.intSetting((String)"search_backpressure.node_duress.num_successive_breaches", (int)3, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile double cpuThreshold;
    public static final Setting<Double> SETTING_CPU_THRESHOLD = Setting.doubleSetting((String)"search_backpressure.node_duress.cpu_threshold", (double)0.9, (double)0.0, (double)1.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile double heapThreshold;
    public static final Setting<Double> SETTING_HEAP_THRESHOLD = Setting.doubleSetting((String)"search_backpressure.node_duress.heap_threshold", (double)0.7, (double)0.0, (double)1.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});

    public NodeDuressSettings(Settings settings, ClusterSettings clusterSettings) {
        this.numSuccessiveBreaches = (Integer)SETTING_NUM_SUCCESSIVE_BREACHES.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SETTING_NUM_SUCCESSIVE_BREACHES, this::setNumSuccessiveBreaches);
        this.cpuThreshold = (Double)SETTING_CPU_THRESHOLD.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CPU_THRESHOLD, this::setCpuThreshold);
        this.heapThreshold = (Double)SETTING_HEAP_THRESHOLD.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SETTING_HEAP_THRESHOLD, this::setHeapThreshold);
    }

    public int getNumSuccessiveBreaches() {
        return this.numSuccessiveBreaches;
    }

    private void setNumSuccessiveBreaches(int numSuccessiveBreaches) {
        this.numSuccessiveBreaches = numSuccessiveBreaches;
    }

    public double getCpuThreshold() {
        return this.cpuThreshold;
    }

    private void setCpuThreshold(double cpuThreshold) {
        this.cpuThreshold = cpuThreshold;
    }

    public double getHeapThreshold() {
        return this.heapThreshold;
    }

    private void setHeapThreshold(double heapThreshold) {
        this.heapThreshold = heapThreshold;
    }

    private static class Defaults {
        private static final int NUM_SUCCESSIVE_BREACHES = 3;
        private static final double CPU_THRESHOLD = 0.9;
        private static final double HEAP_THRESHOLD = 0.7;

        private Defaults() {
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(SETTING_NUM_SUCCESSIVE_BREACHES, SETTING_CPU_THRESHOLD, SETTING_HEAP_THRESHOLD);
        }
    }
}

