/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.settings;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.search.backpressure.SearchBackpressureMode;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.List;
import org.opensearch.search.backpressure.settings.NodeDuressSettings;
import org.opensearch.search.backpressure.settings.SearchShardTaskSettings;
import org.opensearch.search.backpressure.settings.SearchTaskSettings;

public class SearchBackpressureSettings {
    private final TimeValue interval;
    public static final Setting<Long> SETTING_INTERVAL_MILLIS = Setting.longSetting((String)"search_backpressure.interval_millis", (long)1000L, (long)1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private volatile SearchBackpressureMode mode;
    public static final Setting<SearchBackpressureMode> SETTING_MODE = new Setting("search_backpressure.mode", "monitor_only", SearchBackpressureMode::fromName, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Double> SETTING_CANCELLATION_RATIO = Setting.doubleSetting((String)"search_backpressure.cancellation_ratio", (double)0.1, (double)0.0, (double)1.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Double> SETTING_CANCELLATION_RATE = Setting.doubleSetting((String)"search_backpressure.cancellation_rate", (double)0.003, (double)0.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Double> SETTING_CANCELLATION_BURST = Setting.doubleSetting((String)"search_backpressure.cancellation_burst", (double)10.0, (double)1.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final Settings settings;
    private final ClusterSettings clusterSettings;
    private final NodeDuressSettings nodeDuressSettings;
    private final SearchTaskSettings searchTaskSettings;
    private final SearchShardTaskSettings searchShardTaskSettings;

    public SearchBackpressureSettings(Settings settings, ClusterSettings clusterSettings) {
        this.settings = settings;
        this.clusterSettings = clusterSettings;
        this.nodeDuressSettings = new NodeDuressSettings(settings, clusterSettings);
        this.searchTaskSettings = new SearchTaskSettings(settings, clusterSettings);
        this.searchShardTaskSettings = new SearchShardTaskSettings(settings, clusterSettings);
        this.interval = new TimeValue(((Long)SETTING_INTERVAL_MILLIS.get(settings)).longValue());
        this.mode = (SearchBackpressureMode)SETTING_MODE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SETTING_MODE, this::setMode);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CANCELLATION_RATIO, this.searchShardTaskSettings::setCancellationRatio);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CANCELLATION_RATE, this.searchShardTaskSettings::setCancellationRate);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CANCELLATION_BURST, this.searchShardTaskSettings::setCancellationBurst);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public NodeDuressSettings getNodeDuressSettings() {
        return this.nodeDuressSettings;
    }

    public SearchTaskSettings getSearchTaskSettings() {
        return this.searchTaskSettings;
    }

    public SearchShardTaskSettings getSearchShardTaskSettings() {
        return this.searchShardTaskSettings;
    }

    public TimeValue getInterval() {
        return this.interval;
    }

    public SearchBackpressureMode getMode() {
        return this.mode;
    }

    public void setMode(SearchBackpressureMode mode) {
        this.mode = mode;
    }

    private static class Defaults {
        private static final long INTERVAL_MILLIS = 1000L;
        private static final String MODE = "monitor_only";
        private static final double CANCELLATION_RATIO = 0.1;
        private static final double CANCELLATION_RATE = 0.003;
        private static final double CANCELLATION_BURST = 10.0;

        private Defaults() {
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(SETTING_MODE, SETTING_CANCELLATION_RATIO, SETTING_CANCELLATION_RATE, SETTING_CANCELLATION_BURST);
        }
    }
}

