/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.settings;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opensearch.search.backpressure.CancellationSettingsListener;

public class SearchTaskSettings {
    private final List<CancellationSettingsListener> listeners = new ArrayList<CancellationSettingsListener>();
    private final ClusterSettings clusterSettings;
    private volatile double cancellationRatio;
    public static final Setting<Double> SETTING_CANCELLATION_RATIO = Setting.doubleSetting((String)"search_backpressure.search_task.cancellation_ratio", (double)0.1, (double)0.0, (double)1.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile double cancellationRate;
    public static final Setting<Double> SETTING_CANCELLATION_RATE = Setting.doubleSetting((String)"search_backpressure.search_task.cancellation_rate", (double)0.003, (double)0.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile double cancellationBurst;
    public static final Setting<Double> SETTING_CANCELLATION_BURST = Setting.doubleSetting((String)"search_backpressure.search_task.cancellation_burst", (double)5.0, (double)1.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile double totalHeapPercentThreshold;
    public static final Setting<Double> SETTING_TOTAL_HEAP_PERCENT_THRESHOLD = Setting.doubleSetting((String)"search_backpressure.search_task.total_heap_percent_threshold", (double)0.05, (double)0.0, (double)1.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile long cpuTimeMillisThreshold;
    public static final Setting<Long> SETTING_CPU_TIME_MILLIS_THRESHOLD = Setting.longSetting((String)"search_backpressure.search_task.cpu_time_millis_threshold", (long)30000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile long elapsedTimeMillisThreshold;
    public static final Setting<Long> SETTING_ELAPSED_TIME_MILLIS_THRESHOLD = Setting.longSetting((String)"search_backpressure.search_task.elapsed_time_millis_threshold", (long)45000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile double heapPercentThreshold;
    public static final Setting<Double> SETTING_HEAP_PERCENT_THRESHOLD = Setting.doubleSetting((String)"search_backpressure.search_task.heap_percent_threshold", (double)0.02, (double)0.0, (double)1.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile double heapVarianceThreshold;
    public static final Setting<Double> SETTING_HEAP_VARIANCE_THRESHOLD = Setting.doubleSetting((String)"search_backpressure.search_task.heap_variance", (double)2.0, (double)0.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile int heapMovingAverageWindowSize;
    public static final Setting<Integer> SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE = Setting.intSetting((String)"search_backpressure.search_task.heap_moving_average_window_size", (int)100, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});

    public SearchTaskSettings(Settings settings, ClusterSettings clusterSettings) {
        this.totalHeapPercentThreshold = (Double)SETTING_TOTAL_HEAP_PERCENT_THRESHOLD.get(settings);
        this.cpuTimeMillisThreshold = (Long)SETTING_CPU_TIME_MILLIS_THRESHOLD.get(settings);
        this.elapsedTimeMillisThreshold = (Long)SETTING_ELAPSED_TIME_MILLIS_THRESHOLD.get(settings);
        this.heapPercentThreshold = (Double)SETTING_HEAP_PERCENT_THRESHOLD.get(settings);
        this.heapVarianceThreshold = (Double)SETTING_HEAP_VARIANCE_THRESHOLD.get(settings);
        this.heapMovingAverageWindowSize = (Integer)SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE.get(settings);
        this.cancellationRatio = (Double)SETTING_CANCELLATION_RATIO.get(settings);
        this.cancellationRate = (Double)SETTING_CANCELLATION_RATE.get(settings);
        this.cancellationBurst = (Double)SETTING_CANCELLATION_BURST.get(settings);
        this.clusterSettings = clusterSettings;
        clusterSettings.addSettingsUpdateConsumer(SETTING_TOTAL_HEAP_PERCENT_THRESHOLD, this::setTotalHeapPercentThreshold);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CPU_TIME_MILLIS_THRESHOLD, this::setCpuTimeMillisThreshold);
        clusterSettings.addSettingsUpdateConsumer(SETTING_ELAPSED_TIME_MILLIS_THRESHOLD, this::setElapsedTimeMillisThreshold);
        clusterSettings.addSettingsUpdateConsumer(SETTING_HEAP_PERCENT_THRESHOLD, this::setHeapPercentThreshold);
        clusterSettings.addSettingsUpdateConsumer(SETTING_HEAP_VARIANCE_THRESHOLD, this::setHeapVarianceThreshold);
        clusterSettings.addSettingsUpdateConsumer(SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE, this::setHeapMovingAverageWindowSize);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CANCELLATION_RATIO, this::setCancellationRatio);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CANCELLATION_RATE, this::setCancellationRate);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CANCELLATION_BURST, this::setCancellationBurst);
    }

    public double getTotalHeapPercentThreshold() {
        return this.totalHeapPercentThreshold;
    }

    public long getCpuTimeNanosThreshold() {
        return TimeUnit.MILLISECONDS.toNanos(this.cpuTimeMillisThreshold);
    }

    public long getElapsedTimeNanosThreshold() {
        return TimeUnit.MILLISECONDS.toNanos(this.elapsedTimeMillisThreshold);
    }

    public double getHeapPercentThreshold() {
        return this.heapPercentThreshold;
    }

    public double getHeapVarianceThreshold() {
        return this.heapVarianceThreshold;
    }

    public int getHeapMovingAverageWindowSize() {
        return this.heapMovingAverageWindowSize;
    }

    public void setTotalHeapPercentThreshold(double totalHeapPercentThreshold) {
        this.totalHeapPercentThreshold = totalHeapPercentThreshold;
    }

    public void setCpuTimeMillisThreshold(long cpuTimeMillisThreshold) {
        this.cpuTimeMillisThreshold = cpuTimeMillisThreshold;
    }

    public void setElapsedTimeMillisThreshold(long elapsedTimeMillisThreshold) {
        this.elapsedTimeMillisThreshold = elapsedTimeMillisThreshold;
    }

    public void setHeapPercentThreshold(double heapPercentThreshold) {
        this.heapPercentThreshold = heapPercentThreshold;
    }

    public void setHeapVarianceThreshold(double heapVarianceThreshold) {
        this.heapVarianceThreshold = heapVarianceThreshold;
    }

    public void setHeapMovingAverageWindowSize(int heapMovingAverageWindowSize) {
        this.heapMovingAverageWindowSize = heapMovingAverageWindowSize;
    }

    public double getCancellationRatio() {
        return this.cancellationRatio;
    }

    private void setCancellationRatio(double cancellationRatio) {
        this.cancellationRatio = cancellationRatio;
        this.notifyListeners(listener -> listener.onRatioChanged(cancellationRatio));
    }

    public double getCancellationRate() {
        return this.cancellationRate;
    }

    public double getCancellationRateNanos() {
        return this.getCancellationRate() / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    }

    private void setCancellationRate(double cancellationRate) {
        this.cancellationRate = cancellationRate;
        this.notifyListeners(listener -> listener.onRateChanged(cancellationRate));
    }

    public double getCancellationBurst() {
        return this.cancellationBurst;
    }

    private void setCancellationBurst(double cancellationBurst) {
        this.cancellationBurst = cancellationBurst;
        this.notifyListeners(listener -> listener.onBurstChanged(cancellationBurst));
    }

    public void addListener(CancellationSettingsListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners(Consumer<CancellationSettingsListener> consumer) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (CancellationSettingsListener listener : this.listeners) {
            try {
                consumer.accept(listener);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        SkyliteExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
    }

    private static class Defaults {
        private static final double CANCELLATION_RATIO = 0.1;
        private static final double CANCELLATION_RATE = 0.003;
        private static final double CANCELLATION_BURST = 5.0;
        private static final double TOTAL_HEAP_PERCENT_THRESHOLD = 0.05;
        private static final long CPU_TIME_MILLIS_THRESHOLD = 30000L;
        private static final long ELAPSED_TIME_MILLIS_THRESHOLD = 45000L;
        private static final double HEAP_PERCENT_THRESHOLD = 0.02;
        private static final double HEAP_VARIANCE_THRESHOLD = 2.0;
        private static final int HEAP_MOVING_AVERAGE_WINDOW_SIZE = 100;

        private Defaults() {
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(SETTING_CANCELLATION_RATIO, SETTING_CANCELLATION_RATE, SETTING_CANCELLATION_BURST, SETTING_HEAP_PERCENT_THRESHOLD, SETTING_HEAP_VARIANCE_THRESHOLD, SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE, SETTING_CPU_TIME_MILLIS_THRESHOLD, SETTING_ELAPSED_TIME_MILLIS_THRESHOLD, SETTING_TOTAL_HEAP_PERCENT_THRESHOLD);
        }
    }
}

