/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch;

import io.skylite.core.index.query.ParsedQuery;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.search.SearchExtBuilder;
import io.skylite.core.search.fetch.subphase.FetchDocValuesContext;
import io.skylite.core.search.fetch.subphase.FetchFieldsContext;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.search.fetch.subphase.FieldAndFormat;
import io.skylite.core.search.fetch.subphase.ScriptFieldsContext;
import io.skylite.core.search.fetch.subphase.highlight.SearchHighlightContext;
import io.skylite.core.search.internal.ContextIndexSearcher;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.search.lookup.SourceLookup;
import io.skylite.core.search.rescore.RescoreContext;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.subphase.InnerHitsContext;
import org.opensearch.search.internal.SearchContext;

public class FetchContext {
    private final SearchContext searchContext;
    private final SearchLookup searchLookup;

    public FetchContext(SearchContext searchContext) {
        this.searchContext = searchContext;
        this.searchLookup = searchContext.getQueryShardContext().newFetchLookup();
    }

    public String getIndexName() {
        return this.searchContext.indexShard().shardId().getIndexName();
    }

    public ContextIndexSearcher searcher() {
        return this.searchContext.searcher();
    }

    public SearchLookup searchLookup() {
        return this.searchLookup;
    }

    public Query query() {
        return this.searchContext.query();
    }

    public ParsedQuery parsedQuery() {
        return this.searchContext.parsedQuery();
    }

    public ParsedQuery parsedPostFilter() {
        return this.searchContext.parsedPostFilter();
    }

    public FetchSourceContext fetchSourceContext() {
        return this.searchContext.fetchSourceContext();
    }

    public boolean explain() {
        return this.searchContext.explain() && this.searchContext.query() != null;
    }

    public List<RescoreContext> rescore() {
        return this.searchContext.rescore();
    }

    public boolean seqNoAndPrimaryTerm() {
        return this.searchContext.seqNoAndPrimaryTerm();
    }

    public FetchDocValuesContext docValuesContext() {
        FetchDocValuesContext dvContext = this.searchContext.docValuesContext();
        if (this.searchContext.collapse() != null) {
            String name = this.searchContext.collapse().getFieldName();
            if (dvContext == null) {
                return new FetchDocValuesContext(Collections.singletonList(new FieldAndFormat(name, null)));
            }
            if (!this.searchContext.docValuesContext().fields().stream().map(ff -> ff.field).anyMatch(name::equals)) {
                dvContext.fields().add(new FieldAndFormat(name, null));
            }
        }
        return dvContext;
    }

    public SearchHighlightContext highlight() {
        return this.searchContext.highlight();
    }

    public boolean containsBrokenAnalysis(String field) {
        return this.getQueryShardContext().containsBrokenAnalysis(field);
    }

    public boolean fetchScores() {
        return this.searchContext.sort() != null && this.searchContext.trackScores();
    }

    public InnerHitsContext innerHits() {
        return this.searchContext.innerHits();
    }

    public boolean version() {
        return this.searchContext.version();
    }

    public FetchFieldsContext fetchFieldsContext() {
        return this.searchContext.fetchFieldsContext();
    }

    public ScriptFieldsContext scriptFields() {
        return this.searchContext.scriptFields();
    }

    public SearchExtBuilder getSearchExt(String name) {
        return this.searchContext.getSearchExt(name);
    }

    public QueryShardContext getQueryShardContext() {
        return this.searchContext.getQueryShardContext();
    }

    public SourceLookup getRootSourceLookup(FetchSubPhase.HitContext hitContext) {
        if (this.searchContext instanceof InnerHitsContext.InnerHitSubContext && hitContext.hit().getNestedIdentity() != null) {
            InnerHitsContext.InnerHitSubContext innerHitsContext = (InnerHitsContext.InnerHitSubContext)this.searchContext;
            return innerHitsContext.getRootLookup();
        }
        return hitContext.sourceLookup();
    }
}

