/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch;

import io.skylite.common.CheckedBiConsumer;
import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.document.DocumentField;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.storedfieldloader.CustomStoredFieldsLoader;
import io.skylite.core.index.storedfieldloader.StoredFieldsLoader;
import io.skylite.core.lucene.index.SequentialStoredFieldsLeafReader;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.search.SearchContextSourcePrinter;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchHits;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.fetch.StoredFieldsContext;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.search.lookup.SourceLookup;
import io.skylite.core.search.nested.LeafNestedDocuments;
import io.skylite.core.search.nested.NestedDocuments;
import io.skylite.core.tasks.TaskCancelledException;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.TotalHits;
import org.opensearch.index.get.ShardGetService;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchPhaseExecutionException;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;
import org.opensearch.search.fetch.subphase.InnerHitsContext;
import org.opensearch.search.fetch.subphase.InnerHitsPhase;
import org.opensearch.search.internal.SearchContext;

public class FetchPhase {
    private static final Logger LOGGER = LogManager.getLogger(FetchPhase.class);
    private final FetchSubPhase[] fetchSubPhases;

    public FetchPhase(List<FetchSubPhase> fetchSubPhases) {
        this.fetchSubPhases = fetchSubPhases.toArray(new FetchSubPhase[fetchSubPhases.size() + 1]);
        this.fetchSubPhases[fetchSubPhases.size()] = new InnerHitsPhase(this);
    }

    public void execute(SearchContext context) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)new SearchContextSourcePrinter((SearchExecutionContext)context));
        }
        if (context.isCancelled()) {
            throw new TaskCancelledException("cancelled task with reason: " + context.getTask().getReasonCancelled());
        }
        if (context.docIdsToLoadSize() == 0) {
            context.fetchResult().hits(new SearchHits(new SearchHit[0], context.queryResult().getTotalHits(), context.queryResult().getMaxScore()));
            return;
        }
        Object[] docs = new DocIdToIndex[context.docIdsToLoadSize()];
        for (int index = 0; index < context.docIdsToLoadSize(); ++index) {
            docs[index] = new DocIdToIndex(context.docIdsToLoad()[index], index);
        }
        Arrays.sort(docs);
        HashMap<String, Set<String>> storedToRequestedFields = new HashMap<String, Set<String>>();
        StoredFieldsLoader storedFieldsLoader = this.createStoredFieldsLoader(context, storedToRequestedFields);
        FetchContext fetchContext = new FetchContext(context);
        SearchHit[] hits = new SearchHit[context.docIdsToLoadSize()];
        List<FetchSubPhaseProcessor> subphaseProcessors = this.getSubphaseProcessors(context.shardTarget(), fetchContext);
        NestedDocuments nestedDocuments = context.getNestedDocuments();
        int currentReaderIndex = -1;
        LeafReaderContext currentReaderContext = null;
        LeafNestedDocuments leafNestedDocuments = null;
        CheckedBiConsumer fieldReader = null;
        boolean hasSequentialDocs = FetchPhase.hasSequentialDocs((DocIdToIndex[])docs);
        for (int index = 0; index < context.docIdsToLoadSize(); ++index) {
            if (context.isCancelled()) {
                throw new TaskCancelledException("cancelled task with reason: " + context.getTask().getReasonCancelled());
            }
            int docId = ((DocIdToIndex)docs[index]).docId;
            try {
                int readerIndex = ReaderUtil.subIndex((int)docId, (List)context.searcher().getIndexReader().leaves());
                if (currentReaderIndex != readerIndex) {
                    currentReaderContext = (LeafReaderContext)context.searcher().getIndexReader().leaves().get(readerIndex);
                    currentReaderIndex = readerIndex;
                    if (currentReaderContext.reader() instanceof SequentialStoredFieldsLeafReader && hasSequentialDocs && docs.length >= 10) {
                        SequentialStoredFieldsLeafReader lf = (SequentialStoredFieldsLeafReader)currentReaderContext.reader();
                        fieldReader = (arg_0, arg_1) -> ((StoredFieldsReader)lf.getSequentialStoredFieldsReader()).document(arg_0, arg_1);
                    } else {
                        fieldReader = (arg_0, arg_1) -> ((StoredFields)currentReaderContext.reader().storedFields()).document(arg_0, arg_1);
                    }
                    for (FetchSubPhaseProcessor processor : subphaseProcessors) {
                        processor.setNextReader(currentReaderContext);
                    }
                    leafNestedDocuments = nestedDocuments.getLeafNestedDocuments(currentReaderContext);
                }
                assert (currentReaderContext != null);
                FetchSubPhase.HitContext hitContext = this.prepareHitContext(context, leafNestedDocuments, arg_0 -> ((NestedDocuments)nestedDocuments).hasNonNestedParent(arg_0), fetchContext.searchLookup(), storedFieldsLoader, docId, storedToRequestedFields, currentReaderContext, fieldReader);
                for (FetchSubPhaseProcessor subphaseProcessor : subphaseProcessors) {
                    subphaseProcessor.process(hitContext);
                }
                hits[((DocIdToIndex)docs[index]).index] = hitContext.hit();
                continue;
            }
            catch (Exception e) {
                throw new FetchPhaseExecutionException(context.shardTarget(), "Error running fetch phase for doc [" + docId + "]", e);
            }
        }
        if (context.isCancelled()) {
            throw new TaskCancelledException("cancelled task with reason: " + context.getTask().getReasonCancelled());
        }
        TotalHits totalHits = context.queryResult().getTotalHits();
        context.fetchResult().hits(new SearchHits(hits, totalHits, context.queryResult().getMaxScore()));
    }

    private List<FetchSubPhaseProcessor> getSubphaseProcessors(SearchShardTarget target, FetchContext context) {
        try {
            ArrayList<FetchSubPhaseProcessor> processors = new ArrayList<FetchSubPhaseProcessor>();
            for (FetchSubPhase fsp : this.fetchSubPhases) {
                FetchSubPhaseProcessor processor = fsp.getProcessor(context);
                if (processor == null) continue;
                processors.add(processor);
            }
            return processors;
        }
        catch (Exception e) {
            throw new FetchPhaseExecutionException(target, "Error building fetch sub-phases", e);
        }
    }

    private StoredFieldsLoader createStoredFieldsLoader(SearchContext context, Map<String, Set<String>> storedToRequestedFields) {
        StoredFieldsContext storedFieldsContext = context.storedFieldsContext();
        if (storedFieldsContext == null) {
            if (!context.hasScriptFields() && !context.hasFetchSourceContext()) {
                context.fetchSourceContext(new FetchSourceContext(true));
            }
            boolean loadSource = this.sourceRequired(context);
            return new StoredFieldsLoader(loadSource);
        }
        if (!storedFieldsContext.fetchFields()) {
            return null;
        }
        for (String fieldNameOrPattern : context.storedFieldsContext().fieldNames()) {
            if (fieldNameOrPattern.equals(ParseField.CommonMetaFields.SOURCE_FIELD.getPreferredName())) {
                FetchSourceContext fetchSourceContext = context.hasFetchSourceContext() ? context.fetchSourceContext() : FetchSourceContext.FETCH_SOURCE;
                context.fetchSourceContext(new FetchSourceContext(true, fetchSourceContext.includes(), fetchSourceContext.excludes()));
                continue;
            }
            QueryShardContext queryShardContext = context.getQueryShardContext();
            Set fieldNames = queryShardContext.simpleMatchToIndexNames(fieldNameOrPattern);
            for (String fieldName : fieldNames) {
                MappedFieldType fieldType = queryShardContext.getFieldType(fieldName);
                if (fieldType == null) {
                    if (queryShardContext.getObjectMapper(fieldName) == null) continue;
                    throw new IllegalArgumentException("field [" + fieldName + "] isn't a leaf field");
                }
                String storedField = fieldType.name();
                Set requestedFields = storedToRequestedFields.computeIfAbsent(storedField, key -> new HashSet());
                requestedFields.add(fieldName);
            }
        }
        boolean loadSource = this.sourceRequired(context);
        if (storedToRequestedFields.isEmpty()) {
            return new StoredFieldsLoader(loadSource);
        }
        return new CustomStoredFieldsLoader(storedToRequestedFields.keySet(), loadSource);
    }

    private boolean sourceRequired(SearchContext context) {
        return context.sourceRequested() || context.fetchFieldsContext() != null;
    }

    private FetchSubPhase.HitContext prepareHitContext(SearchContext context, LeafNestedDocuments nestedDocuments, Predicate<String> hasNonNestedParent, SearchLookup lookup, StoredFieldsLoader storedFieldsLoader, int docId, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext, CheckedBiConsumer<Integer, StoredFieldsLoader, IOException> storedFieldReader) throws IOException {
        if (nestedDocuments.advance(docId - subReaderContext.docBase) == null) {
            return this.prepareNonNestedHitContext(context, lookup, storedFieldsLoader, docId, storedToRequestedFields, subReaderContext, storedFieldReader);
        }
        return this.prepareNestedHitContext(context, docId, nestedDocuments, hasNonNestedParent, storedToRequestedFields, subReaderContext, storedFieldReader);
    }

    private FetchSubPhase.HitContext prepareNonNestedHitContext(SearchContext context, SearchLookup lookup, StoredFieldsLoader storedFieldsLoader, int docId, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext, CheckedBiConsumer<Integer, StoredFieldsLoader, IOException> fieldReader) throws IOException {
        SearchHit hit;
        int subDocId = docId - subReaderContext.docBase;
        if (storedFieldsLoader == null) {
            SearchHit hit2 = new SearchHit(docId, null, null, null);
            return new FetchSubPhase.HitContext(hit2, subReaderContext, subDocId, lookup.source());
        }
        this.loadStoredFields(arg_0 -> ((QueryShardContext)context.getQueryShardContext()).getFieldType(arg_0), fieldReader, storedFieldsLoader, subDocId);
        String id = storedFieldsLoader.id();
        if (!storedFieldsLoader.fields().isEmpty()) {
            HashMap<String, DocumentField> docFields = new HashMap<String, DocumentField>();
            HashMap<String, DocumentField> metaFields = new HashMap<String, DocumentField>();
            FetchPhase.fillDocAndMetaFields(context, storedFieldsLoader, storedToRequestedFields, docFields, metaFields);
            hit = new SearchHit(docId, id, docFields, metaFields);
        } else {
            hit = new SearchHit(docId, id, Collections.emptyMap(), Collections.emptyMap());
        }
        FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext(hit, subReaderContext, subDocId, lookup.source());
        if (storedFieldsLoader.source() != null) {
            hitContext.sourceLookup().setSource(storedFieldsLoader.source());
        }
        return hitContext;
    }

    private FetchSubPhase.HitContext prepareNestedHitContext(SearchContext context, int topDocId, LeafNestedDocuments nestedInfo, Predicate<String> hasNonNestedParent, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext, CheckedBiConsumer<Integer, StoredFieldsLoader, IOException> storedFieldReader) throws IOException {
        String rootId;
        boolean needSource = this.sourceRequired(context) || context.highlight() != null;
        Map rootSourceAsMap = null;
        MediaType rootSourceContentType = null;
        QueryShardContext queryShardContext = context.getQueryShardContext();
        if (context instanceof InnerHitsContext.InnerHitSubContext) {
            InnerHitsContext.InnerHitSubContext innerHitsContext = (InnerHitsContext.InnerHitSubContext)context;
            rootId = innerHitsContext.getId();
            if (needSource) {
                SourceLookup rootLookup = innerHitsContext.getRootLookup();
                rootSourceAsMap = rootLookup.loadSourceIfNeeded();
                rootSourceContentType = rootLookup.sourceContentType();
            }
        } else {
            StoredFieldsLoader rootStoredFieldsLoader = new StoredFieldsLoader(needSource);
            this.loadStoredFields(arg_0 -> ((QueryShardContext)queryShardContext).getFieldType(arg_0), storedFieldReader, rootStoredFieldsLoader, nestedInfo.rootDoc());
            rootId = rootStoredFieldsLoader.id();
            if (needSource) {
                if (rootStoredFieldsLoader.source() != null) {
                    Tuple tuple = XContentHelper.convertToMap((BytesReference)rootStoredFieldsLoader.source(), (boolean)false);
                    rootSourceAsMap = (Map)tuple.v2();
                    rootSourceContentType = (MediaType)tuple.v1();
                } else {
                    rootSourceAsMap = Collections.emptyMap();
                }
            }
        }
        Map<String, DocumentField> docFields = Collections.emptyMap();
        Map<String, DocumentField> metaFields = Collections.emptyMap();
        if (context.hasStoredFields() && !context.storedFieldsContext().fieldNames().isEmpty()) {
            CustomStoredFieldsLoader nestedStoredFieldsLoader = new CustomStoredFieldsLoader(storedToRequestedFields.keySet(), false);
            this.loadStoredFields(arg_0 -> ((QueryShardContext)queryShardContext).getFieldType(arg_0), storedFieldReader, (StoredFieldsLoader)nestedStoredFieldsLoader, nestedInfo.doc());
            if (!nestedStoredFieldsLoader.fields().isEmpty()) {
                docFields = new HashMap();
                metaFields = new HashMap();
                FetchPhase.fillDocAndMetaFields(context, (StoredFieldsLoader)nestedStoredFieldsLoader, storedToRequestedFields, docFields, metaFields);
            }
        }
        SearchHit.NestedIdentity nestedIdentity = nestedInfo.nestedIdentity();
        SearchHit hit = new SearchHit(topDocId, rootId, nestedIdentity, docFields, metaFields);
        FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext(hit, subReaderContext, nestedInfo.doc(), new SourceLookup());
        if (rootSourceAsMap != null && !rootSourceAsMap.isEmpty()) {
            HashMap<String, Map> nestedSourceAsMap;
            HashMap<String, Map> current = nestedSourceAsMap = new HashMap<String, Map>();
            for (SearchHit.NestedIdentity nested = nestedIdentity; nested != null; nested = nested.getChild()) {
                List<Object> nestedParsedSource;
                String nestedPath = nested.getField().string();
                current.put(nestedPath, new HashMap());
                Object extractedValue = XContentMapValuesUtil.extractValue((String)nestedPath, (Map)rootSourceAsMap);
                if (extractedValue instanceof List) {
                    nestedParsedSource = (List<Object>)extractedValue;
                } else if (extractedValue instanceof Map) {
                    nestedParsedSource = Collections.singletonList(extractedValue);
                } else {
                    throw new IllegalStateException("extracted source isn't an object or an array");
                }
                if (!(nestedParsedSource.get(0) instanceof Map) && hasNonNestedParent.test(nestedPath)) {
                    throw new IllegalArgumentException("Cannot execute inner hits. One or more parent object fields of nested field [" + nestedPath + "] are not nested. All parent fields need to be nested fields too");
                }
                rootSourceAsMap = (Map)nestedParsedSource.get(nested.getOffset());
                if (nested.getChild() == null) {
                    current.put(nestedPath, rootSourceAsMap);
                    continue;
                }
                HashMap next = new HashMap();
                current.put(nestedPath, next);
                current = next;
            }
            hitContext.sourceLookup().setSource(nestedSourceAsMap);
            hitContext.sourceLookup().setSourceContentType(rootSourceContentType);
        }
        return hitContext;
    }

    private void loadStoredFields(Function<String, BaseMappedFieldType> fieldTypeLookup, CheckedBiConsumer<Integer, StoredFieldsLoader, IOException> fieldReader, StoredFieldsLoader fieldVisitor, int docId) throws IOException {
        fieldVisitor.reset();
        fieldReader.accept((Object)docId, (Object)fieldVisitor);
        ShardGetService.loadStoredFields(fieldVisitor, fieldTypeLookup);
    }

    private static void fillDocAndMetaFields(SearchContext context, StoredFieldsLoader storedFieldsLoader, Map<String, Set<String>> storedToRequestedFields, Map<String, DocumentField> docFields, Map<String, DocumentField> metaFields) {
        for (Map.Entry entry : storedFieldsLoader.fields().entrySet()) {
            String storedField = (String)entry.getKey();
            List storedValues = (List)entry.getValue();
            if (storedToRequestedFields.containsKey(storedField)) {
                for (String requestedField : storedToRequestedFields.get(storedField)) {
                    if (context.getQueryShardContext().isMetadataField(requestedField)) {
                        metaFields.put(requestedField, new DocumentField(requestedField, storedValues));
                        continue;
                    }
                    docFields.put(requestedField, new DocumentField(requestedField, storedValues));
                }
                continue;
            }
            if (context.getQueryShardContext().isMetadataField(storedField)) {
                metaFields.put(storedField, new DocumentField(storedField, storedValues));
                continue;
            }
            docFields.put(storedField, new DocumentField(storedField, storedValues));
        }
    }

    static boolean hasSequentialDocs(DocIdToIndex[] docs) {
        return docs.length > 0 && docs[docs.length - 1].docId - docs[0].docId == docs.length - 1;
    }

    static class DocIdToIndex
    implements Comparable<DocIdToIndex> {
        final int docId;
        final int index;

        DocIdToIndex(int docId, int index) {
            this.docId = docId;
            this.index = index;
        }

        @Override
        public int compareTo(DocIdToIndex o) {
            return Integer.compare(this.docId, o.docId);
        }
    }
}

