/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase;

import io.skylite.core.common.document.DocumentField;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.ValueFetcher;
import io.skylite.core.search.fetch.subphase.FetchDocValuesContext;
import io.skylite.core.search.fetch.subphase.FieldAndFormat;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.index.mapper.DocValueFetcher;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;

public final class FetchDocValuesPhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext context) {
        FetchDocValuesContext dvContext = context.docValuesContext();
        if (dvContext == null) {
            return null;
        }
        final ArrayList<DocValueField> fields = new ArrayList<DocValueField>();
        for (FieldAndFormat fieldAndFormat : context.docValuesContext().fields()) {
            MappedFieldType ft = context.getQueryShardContext().getFieldType(fieldAndFormat.field);
            if (ft == null) continue;
            DocValueFetcher fetcher = new DocValueFetcher(ft.docValueFormat(fieldAndFormat.format, null), context.searchLookup().getForField((BaseMappedFieldType)ft));
            fields.add(new DocValueField(fieldAndFormat.field, fetcher));
        }
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
                for (DocValueField f : fields) {
                    f.fetcher.setNextReader(readerContext);
                }
            }

            @Override
            public void process(FetchSubPhase.HitContext hit) throws IOException {
                for (DocValueField f : fields) {
                    DocumentField hitField = hit.hit().field(f.field);
                    if (hitField == null) {
                        hitField = new DocumentField(f.field, new ArrayList(2));
                        hit.hit().setDocumentField(f.field, hitField);
                    }
                    hitField.getValues().addAll(f.fetcher.fetchValues(hit.sourceLookup()));
                }
            }
        };
    }

    private static class DocValueField {
        private final String field;
        private final ValueFetcher fetcher;

        DocValueField(String field, ValueFetcher fetcher) {
            this.field = field;
            this.fetcher = fetcher;
        }
    }
}

