/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase.highlight;

import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.storedfieldloader.CustomStoredFieldsLoader;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.ValueFetcher;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.opensearch.search.fetch.FetchSubPhase;

public final class HighlightUtils {
    public static final char PARAGRAPH_SEPARATOR = '\u2029';
    public static final char NULL_SEPARATOR = '\u0000';

    private HighlightUtils() {
    }

    public static List<Object> loadFieldValues(MappedFieldType fieldType, QueryShardContext context, FetchSubPhase.HitContext hitContext, boolean forceSource) throws IOException {
        if (!forceSource && fieldType.isStored()) {
            CustomStoredFieldsLoader fieldVisitor = new CustomStoredFieldsLoader(Collections.singleton(fieldType.name()), false);
            hitContext.reader().storedFields().document(hitContext.docId(), (StoredFieldVisitor)fieldVisitor);
            List<Object> textsToHighlight = (List<Object>)fieldVisitor.fields().get(fieldType.name());
            return textsToHighlight != null ? textsToHighlight : Collections.emptyList();
        }
        ValueFetcher fetcher = fieldType.valueFetcher(context, null, null);
        fetcher.setNextReader(hitContext.readerContext());
        return fetcher.fetchValues(hitContext.sourceLookup());
    }

    public static class Encoders {
        public static final Encoder DEFAULT = new DefaultEncoder();
        public static final Encoder HTML = new SimpleHTMLEncoder();
    }
}

