/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tasks.consumer;

import io.skylite.common.collect.Tuple;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.search.SearchShardTask;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.resourcetracker.ResourceStats;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.opensearch.tasks.consumer.SearchShardTaskDetailsLogMessage;

public class TopNSearchTasksLogger
implements Consumer<Task> {
    public static final String TASK_DETAILS_LOG_PREFIX = "task.detailslog";
    private static final String LOG_TOP_QUERIES_SIZE = "cluster.task.consumers.top_n.size";
    private static final String LOG_TOP_QUERIES_FREQUENCY = "cluster.task.consumers.top_n.frequency";
    private static final Logger SEARCH_TASK_DETAILS_LOGGER = LogManager.getLogger((String)"task.detailslog.search");
    public static final Setting<Integer> LOG_TOP_QUERIES_SIZE_SETTING = Setting.intSetting((String)"cluster.task.consumers.top_n.size", (int)10, (int)1, (int)100, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> LOG_TOP_QUERIES_FREQUENCY_SETTING = Setting.timeSetting((String)"cluster.task.consumers.top_n.frequency", (TimeValue)TimeValue.timeValueSeconds((long)60L), (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private volatile int topQueriesSize;
    private volatile long topQueriesLogFrequencyInNanos;
    private final Queue<Tuple<Long, SearchShardTask>> topQueries;
    private long lastReportedTimeInNanos = System.nanoTime();

    public TopNSearchTasksLogger(Settings settings, ClusterSettings clusterSettings) {
        this.topQueriesSize = (Integer)LOG_TOP_QUERIES_SIZE_SETTING.get(settings);
        this.topQueriesLogFrequencyInNanos = ((TimeValue)LOG_TOP_QUERIES_FREQUENCY_SETTING.get(settings)).getNanos();
        this.topQueries = new PriorityQueue<Tuple>(this.topQueriesSize, Comparator.comparingLong(Tuple::v1));
        clusterSettings.addSettingsUpdateConsumer(LOG_TOP_QUERIES_SIZE_SETTING, this::setLogTopQueriesSize);
        clusterSettings.addSettingsUpdateConsumer(LOG_TOP_QUERIES_FREQUENCY_SETTING, this::setTopQueriesLogFrequencyInNanos);
    }

    @Override
    public void accept(Task task) {
        if (task instanceof SearchShardTask) {
            this.recordSearchTask((SearchShardTask)task);
        }
    }

    private synchronized void recordSearchTask(SearchShardTask searchTask) {
        long memory_in_bytes = searchTask.getTotalResourceUtilization(ResourceStats.MEMORY);
        if (System.nanoTime() - this.lastReportedTimeInNanos >= this.topQueriesLogFrequencyInNanos) {
            this.publishTopNEvents();
            this.lastReportedTimeInNanos = System.nanoTime();
        }
        int topQSize = this.topQueriesSize;
        if (this.topQueries.size() >= topQSize && (Long)this.topQueries.peek().v1() < memory_in_bytes) {
            this.topQueries.poll();
        }
        if (this.topQueries.size() < topQSize) {
            this.topQueries.offer((Tuple<Long, SearchShardTask>)new Tuple((Object)memory_in_bytes, (Object)searchTask));
        }
    }

    private void publishTopNEvents() {
        this.logTopResourceConsumingQueries();
        this.topQueries.clear();
    }

    private void logTopResourceConsumingQueries() {
        for (Tuple tuple : this.topQueries) {
            SEARCH_TASK_DETAILS_LOGGER.info((Message)new SearchShardTaskDetailsLogMessage((SearchShardTask)tuple.v2()));
        }
    }

    private void setLogTopQueriesSize(int topQueriesSize) {
        this.topQueriesSize = topQueriesSize;
    }

    void setTopQueriesLogFrequencyInNanos(TimeValue timeValue) {
        this.topQueriesLogFrequencyInNanos = timeValue.getNanos();
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(LOG_TOP_QUERIES_SIZE_SETTING, LOG_TOP_QUERIES_FREQUENCY_SETTING);
        }
    }
}

