/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.metrics;

import io.skylite.common.annotation.InternalApi;
import io.skylite.core.telemetry.metrics.DefaultMetricsRegistry;
import io.skylite.core.telemetry.metrics.MetricsRegistry;
import io.skylite.core.telemetry.metrics.MetricsTelemetry;
import io.skylite.telemetry.Telemetry;
import io.skylite.telemetry.metrics.noop.NoopMetricsRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.telemetry.TelemetrySettings;

@InternalApi
public class MetricsRegistryFactory
implements Closeable {
    private static final Logger logger = LogManager.getLogger(MetricsRegistryFactory.class);
    private final TelemetrySettings telemetrySettings;
    private final MetricsRegistry metricsRegistry;

    public MetricsRegistryFactory(TelemetrySettings telemetrySettings, Optional<Telemetry> telemetry) {
        this.telemetrySettings = telemetrySettings;
        this.metricsRegistry = this.metricsRegistry(telemetry);
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    @Override
    public void close() {
        try {
            this.metricsRegistry.close();
        }
        catch (IOException e) {
            logger.warn("Error closing MetricsRegistry", (Throwable)e);
        }
    }

    private MetricsRegistry metricsRegistry(Optional<Telemetry> telemetry) {
        MetricsRegistry metricsRegistry = telemetry.map(Telemetry::getMetricsTelemetry).map(metricsTelemetry -> this.createDefaultMetricsRegistry((MetricsTelemetry)metricsTelemetry)).orElse((MetricsRegistry)NoopMetricsRegistry.INSTANCE);
        return metricsRegistry;
    }

    private MetricsRegistry createDefaultMetricsRegistry(MetricsTelemetry metricsTelemetry) {
        return new DefaultMetricsRegistry(metricsTelemetry);
    }
}

