/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing;

import io.skylite.common.annotation.InternalApi;
import io.skylite.common.telemetry.tracing.DefaultTracer;
import io.skylite.common.telemetry.tracing.Span;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.common.telemetry.tracing.TracerContextStorage;
import io.skylite.common.telemetry.tracing.TracingTelemetry;
import io.skylite.common.telemetry.tracing.noop.NoopTracer;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.telemetry.Telemetry;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.telemetry.TelemetrySettings;
import org.opensearch.telemetry.tracing.ThreadContextBasedTracerContextStorage;
import org.opensearch.telemetry.tracing.WrappedTracer;

@InternalApi
public class TracerFactory
implements Closeable {
    private static final Logger logger = LogManager.getLogger(TracerFactory.class);
    private final TelemetrySettings telemetrySettings;
    private final Tracer tracer;

    public TracerFactory(TelemetrySettings telemetrySettings, Optional<Telemetry> telemetry, ThreadContext threadContext) {
        this.telemetrySettings = telemetrySettings;
        this.tracer = this.tracer(telemetry, threadContext);
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    @Override
    public void close() {
        try {
            this.tracer.close();
        }
        catch (IOException e) {
            logger.warn("Error closing tracer", (Throwable)e);
        }
    }

    protected TracerContextStorage<String, Span> createTracerContextStorage(TracingTelemetry tracingTelemetry, ThreadContext threadContext) {
        return new ThreadContextBasedTracerContextStorage(threadContext, tracingTelemetry);
    }

    private Tracer tracer(Optional<Telemetry> telemetry, ThreadContext threadContext) {
        return telemetry.map(Telemetry::getTracingTelemetry).map(tracingTelemetry -> this.createDefaultTracer((TracingTelemetry)tracingTelemetry, threadContext)).map(defaultTracer -> this.createWrappedTracer((Tracer)defaultTracer)).orElse(NoopTracer.INSTANCE);
    }

    private Tracer createDefaultTracer(TracingTelemetry tracingTelemetry, ThreadContext threadContext) {
        TracerContextStorage<String, Span> tracerContextStorage = this.createTracerContextStorage(tracingTelemetry, threadContext);
        return new DefaultTracer(tracingTelemetry, tracerContextStorage);
    }

    private Tracer createWrappedTracer(Tracer defaultTracer) {
        return new WrappedTracer(this.telemetrySettings, defaultTracer);
    }
}

