/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing;

import io.skylite.common.annotation.InternalApi;
import io.skylite.common.telemetry.tracing.ScopedSpan;
import io.skylite.common.telemetry.tracing.Span;
import io.skylite.common.telemetry.tracing.SpanContext;
import io.skylite.common.telemetry.tracing.SpanCreationContext;
import io.skylite.common.telemetry.tracing.SpanScope;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.common.telemetry.tracing.noop.NoopTracer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.opensearch.telemetry.TelemetrySettings;

@InternalApi
final class WrappedTracer
implements Tracer {
    private final Tracer defaultTracer;
    private final TelemetrySettings telemetrySettings;

    public WrappedTracer(TelemetrySettings telemetrySettings, Tracer defaultTracer) {
        this.defaultTracer = defaultTracer;
        this.telemetrySettings = telemetrySettings;
    }

    public Span startSpan(SpanCreationContext context) {
        return this.getDelegateTracer().startSpan(context);
    }

    public SpanContext getCurrentSpan() {
        Tracer delegateTracer = this.getDelegateTracer();
        return delegateTracer.getCurrentSpan();
    }

    public ScopedSpan startScopedSpan(SpanCreationContext spanCreationContext) {
        return this.getDelegateTracer().startScopedSpan(spanCreationContext);
    }

    public SpanScope withSpanInScope(Span span) {
        return this.getDelegateTracer().withSpanInScope(span);
    }

    public boolean isRecording() {
        return this.getDelegateTracer().isRecording();
    }

    public void close() throws IOException {
        this.defaultTracer.close();
    }

    Tracer getDelegateTracer() {
        return this.telemetrySettings.isTracingEnabled() ? this.defaultTracer : NoopTracer.INSTANCE;
    }

    public Span startSpan(SpanCreationContext spanCreationContext, Map<String, Collection<String>> headers) {
        return this.defaultTracer.startSpan(spanCreationContext, headers);
    }
}

