/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing.channels;

import io.skylite.common.action.ActionListener;
import io.skylite.common.telemetry.tracing.Span;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.core.http.HttpChannel;
import io.skylite.core.http.HttpResponse;
import io.skylite.core.telemetry.tracing.listener.TraceableActionListener;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;

public class TraceableHttpChannel
implements HttpChannel {
    private final HttpChannel delegate;
    private final Span span;
    private final Tracer tracer;

    private TraceableHttpChannel(HttpChannel delegate, Span span, Tracer tracer) {
        this.span = Objects.requireNonNull(span);
        this.delegate = Objects.requireNonNull(delegate);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public static HttpChannel create(HttpChannel delegate, Span span, Tracer tracer) {
        if (tracer.isRecording()) {
            return new TraceableHttpChannel(delegate, span, tracer);
        }
        return delegate;
    }

    public void handleException(Exception ex) {
        this.span.addEvent("The HttpChannel was closed without sending the response");
        this.span.setError(ex);
        this.span.endSpan();
    }

    public void close() {
        this.delegate.close();
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.delegate.addCloseListener(listener);
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public void sendResponse(HttpResponse response, ActionListener<Void> listener) {
        this.delegate.sendResponse(response, TraceableActionListener.create(listener, (Span)this.span, (Tracer)this.tracer));
    }

    public InetSocketAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    public <T> Optional<T> get(String name, Class<T> clazz) {
        return this.delegate.get(name, clazz);
    }
}

