/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.watcher;

import io.skylite.common.annotation.PublicApi;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.watcher.ResourceWatcher;
import org.opensearch.watcher.WatcherHandle;

@PublicApi(since="1.0.0")
public class ResourceWatcherService
implements Closeable {
    private static final Logger logger = LogManager.getLogger(ResourceWatcherService.class);
    public static final Setting<Boolean> ENABLED = Setting.boolSetting((String)"resource.reload.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> RELOAD_INTERVAL_HIGH = Setting.timeSetting((String)"resource.reload.interval.high", (TimeValue)Frequency.HIGH.interval, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> RELOAD_INTERVAL_MEDIUM = Setting.timeSetting((String)"resource.reload.interval.medium", (Setting)Setting.timeSetting((String)"resource.reload.interval", (TimeValue)Frequency.MEDIUM.interval, (Setting.Property[])new Setting.Property[0]), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> RELOAD_INTERVAL_LOW = Setting.timeSetting((String)"resource.reload.interval.low", (TimeValue)Frequency.LOW.interval, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final boolean enabled;
    final ResourceMonitor lowMonitor;
    final ResourceMonitor mediumMonitor;
    final ResourceMonitor highMonitor;
    private final Scheduler.Cancellable lowFuture;
    private final Scheduler.Cancellable mediumFuture;
    private final Scheduler.Cancellable highFuture;

    public ResourceWatcherService(Settings settings, ThreadPool threadPool) {
        this.enabled = (Boolean)ENABLED.get(settings);
        TimeValue interval = (TimeValue)RELOAD_INTERVAL_LOW.get(settings);
        this.lowMonitor = new ResourceMonitor(interval, Frequency.LOW);
        interval = (TimeValue)RELOAD_INTERVAL_MEDIUM.get(settings);
        this.mediumMonitor = new ResourceMonitor(interval, Frequency.MEDIUM);
        interval = (TimeValue)RELOAD_INTERVAL_HIGH.get(settings);
        this.highMonitor = new ResourceMonitor(interval, Frequency.HIGH);
        if (this.enabled) {
            this.lowFuture = threadPool.scheduleWithFixedDelay((Runnable)this.lowMonitor, this.lowMonitor.interval, "same");
            this.mediumFuture = threadPool.scheduleWithFixedDelay((Runnable)this.mediumMonitor, this.mediumMonitor.interval, "same");
            this.highFuture = threadPool.scheduleWithFixedDelay((Runnable)this.highMonitor, this.highMonitor.interval, "same");
        } else {
            this.lowFuture = null;
            this.mediumFuture = null;
            this.highFuture = null;
        }
    }

    @Override
    public void close() {
        if (this.enabled) {
            this.lowFuture.cancel();
            this.mediumFuture.cancel();
            this.highFuture.cancel();
        }
    }

    public <W extends ResourceWatcher> WatcherHandle<W> add(W watcher) throws IOException {
        return this.add(watcher, Frequency.MEDIUM);
    }

    public <W extends ResourceWatcher> WatcherHandle<W> add(W watcher, Frequency frequency) throws IOException {
        watcher.init();
        switch (frequency.ordinal()) {
            case 2: {
                return this.lowMonitor.add(watcher);
            }
            case 1: {
                return this.mediumMonitor.add(watcher);
            }
            case 0: {
                return this.highMonitor.add(watcher);
            }
        }
        throw new IllegalArgumentException("Unknown frequency [" + String.valueOf((Object)frequency) + "]");
    }

    public void notifyNow(Frequency frequency) {
        switch (frequency.ordinal()) {
            case 2: {
                this.lowMonitor.run();
                break;
            }
            case 1: {
                this.mediumMonitor.run();
                break;
            }
            case 0: {
                this.highMonitor.run();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown frequency [" + String.valueOf((Object)frequency) + "]");
            }
        }
    }

    static class ResourceMonitor
    implements Runnable {
        final TimeValue interval;
        final Frequency frequency;
        final Set<ResourceWatcher> watchers = new CopyOnWriteArraySet<ResourceWatcher>();

        private ResourceMonitor(TimeValue interval, Frequency frequency) {
            this.interval = interval;
            this.frequency = frequency;
        }

        private <W extends ResourceWatcher> WatcherHandle<W> add(W watcher) {
            this.watchers.add(watcher);
            return new WatcherHandle<W>(this, watcher);
        }

        @Override
        public synchronized void run() {
            for (ResourceWatcher watcher : this.watchers) {
                try {
                    watcher.checkAndNotify();
                }
                catch (IOException e) {
                    logger.trace("failed to check resource watcher", (Throwable)e);
                }
            }
        }
    }

    public static enum Frequency {
        HIGH(TimeValue.timeValueSeconds((long)5L)),
        MEDIUM(TimeValue.timeValueSeconds((long)30L)),
        LOW(TimeValue.timeValueSeconds((long)60L));

        final TimeValue interval;

        private Frequency(TimeValue interval) {
            this.interval = interval;
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(ENABLED, RELOAD_INTERVAL_HIGH, RELOAD_INTERVAL_MEDIUM, RELOAD_INTERVAL_LOW);
        }
    }
}

