/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.script.mustache;

import io.skylite.core.ParseField;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.StatusToXContentObject;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class SearchTemplateResponse
extends ActionResponse
implements StatusToXContentObject {
    public static ParseField TEMPLATE_OUTPUT_FIELD = new ParseField("template_output", new String[0]);
    private BytesReference source;
    private SearchResponse response;

    SearchTemplateResponse() {
    }

    SearchTemplateResponse(StreamInput in) throws IOException {
        super(in);
        this.source = in.readOptionalBytesReference();
        this.response = (SearchResponse)in.readOptionalWriteable(SearchResponse::new);
    }

    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(BytesReference source) {
        this.source = source;
    }

    public SearchResponse getResponse() {
        return this.response;
    }

    public void setResponse(SearchResponse searchResponse) {
        this.response = searchResponse;
    }

    public boolean hasResponse() {
        return this.response != null;
    }

    public String toString() {
        return "SearchTemplateResponse [source=" + String.valueOf(this.source) + ", response=" + String.valueOf(this.response) + "]";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBytesReference(this.source);
        out.writeOptionalWriteable((Writeable)this.response);
    }

    public static SearchTemplateResponse fromXContent(XContentParser parser) throws IOException {
        SearchTemplateResponse searchTemplateResponse = new SearchTemplateResponse();
        Map contentAsMap = parser.map();
        if (contentAsMap.containsKey(TEMPLATE_OUTPUT_FIELD.getPreferredName())) {
            Object source = contentAsMap.get(TEMPLATE_OUTPUT_FIELD.getPreferredName());
            XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)MediaTypeRegistry.JSON).value(source);
            searchTemplateResponse.setSource(BytesReference.bytes((XContentBuilder)builder));
        } else {
            MediaType contentType = parser.contentType();
            XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)contentType).map(contentAsMap);
            XContentParser searchResponseParser = contentType.xContent().createParser(parser.getXContentRegistry(), parser.getDeprecationHandler(), (InputStream)BytesReference.bytes((XContentBuilder)builder).streamInput());
            SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)searchResponseParser);
            searchTemplateResponse.setResponse(searchResponse);
        }
        return searchTemplateResponse;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.hasResponse()) {
            this.response.toXContent(builder, params);
        } else {
            builder.startObject();
            try (StreamInput stream = this.source.streamInput();){
                builder.rawField(TEMPLATE_OUTPUT_FIELD.getPreferredName(), (InputStream)stream, MediaTypeRegistry.JSON);
            }
            builder.endObject();
        }
        return builder;
    }

    public RestStatus status() {
        if (this.hasResponse()) {
            return this.response.status();
        }
        return RestStatus.OK;
    }
}

