/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.http.netty4.ssl;

import io.lucenia.http.netty4.Netty4HttpChannel;
import io.lucenia.http.netty4.Netty4HttpServerTransport;
import io.lucenia.transport.SharedGroupFactory;
import io.lucenia.transport.netty4.ssl.SslUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslHandler;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.core.common.network.NetworkService;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.http.HttpChannel;
import io.skylite.core.http.HttpServerTransport;
import io.skylite.core.plugins.SecureHttpTransportSettingsProvider;
import io.skylite.core.plugins.TransportExceptionHandler;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportAdapterProvider;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.http.HttpHandlingSettings;

public class SecureNetty4HttpServerTransport
extends Netty4HttpServerTransport {
    public static final String REQUEST_HEADER_VERIFIER = "HeaderVerifier";
    public static final String REQUEST_DECOMPRESSOR = "RequestDecompressor";
    private static final Logger logger = LogManager.getLogger(SecureNetty4HttpServerTransport.class);
    private final SecureHttpTransportSettingsProvider secureHttpTransportSettingsProvider;
    private final TransportExceptionHandler exceptionHandler;
    private final ChannelInboundHandlerAdapter headerVerifier;
    private final TransportAdapterProvider<HttpServerTransport> decompressorProvider;

    public SecureNetty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry namedXContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, SecureHttpTransportSettingsProvider secureHttpTransportSettingsProvider, Tracer tracer) {
        super(settings, networkService, bigArrays, threadPool, namedXContentRegistry, dispatcher, clusterSettings, sharedGroupFactory, tracer);
        this.secureHttpTransportSettingsProvider = secureHttpTransportSettingsProvider;
        this.exceptionHandler = secureHttpTransportSettingsProvider.buildHttpServerExceptionHandler(settings, (HttpServerTransport)this).orElse(TransportExceptionHandler.NOOP);
        List headerVerifiers = secureHttpTransportSettingsProvider.getHttpTransportAdapterProviders(settings).stream().filter(p -> REQUEST_HEADER_VERIFIER.equalsIgnoreCase(p.name())).map(p -> p.create(settings, (Object)this, ChannelInboundHandlerAdapter.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (headerVerifiers.size() > 1) {
            throw new IllegalArgumentException("Cannot have more than one header verifier configured, supplied " + headerVerifiers.size());
        }
        Optional<TransportAdapterProvider> decompressorProviderOpt = secureHttpTransportSettingsProvider.getHttpTransportAdapterProviders(settings).stream().filter(p -> REQUEST_DECOMPRESSOR.equalsIgnoreCase(p.name())).findFirst();
        decompressorProviderOpt.ifPresent(p -> logger.debug("Using request decompressor provider: {}", p));
        this.headerVerifier = headerVerifiers.isEmpty() ? null : (ChannelInboundHandlerAdapter)headerVerifiers.get(0);
        this.decompressorProvider = decompressorProviderOpt.orElseGet(() -> new TransportAdapterProvider<HttpServerTransport>(this){

            public String name() {
                return SecureNetty4HttpServerTransport.REQUEST_DECOMPRESSOR;
            }

            public <C> Optional<C> create(Settings settings, HttpServerTransport transport, Class<C> adapterClass) {
                return Optional.empty();
            }
        });
    }

    @Override
    public ChannelHandler configureServerChannelHandler() {
        return new SslHttpChannelHandler(this, this.handlingSettings);
    }

    @Override
    public void onException(HttpChannel channel, Exception cause0) {
        Throwable cause = cause0;
        if (cause0 instanceof DecoderException && cause0 != null) {
            cause = cause0.getCause();
        }
        this.exceptionHandler.onError(cause);
        logger.error("Exception during establishing a SSL connection: " + String.valueOf(cause), cause);
        super.onException(channel, cause0);
    }

    @Override
    protected ChannelInboundHandlerAdapter createHeaderVerifier() {
        if (this.headerVerifier != null) {
            return this.headerVerifier;
        }
        return super.createHeaderVerifier();
    }

    @Override
    protected ChannelInboundHandlerAdapter createDecompressor() {
        return this.decompressorProvider.create(this.settings, (Object)this, ChannelInboundHandlerAdapter.class).orElseGet(() -> super.createDecompressor());
    }

    protected class SslHttpChannelHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        protected SslHttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings) {
            super(transport, handlingSettings);
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SSLEngine sslEngine = SecureNetty4HttpServerTransport.this.secureHttpTransportSettingsProvider.buildSecureHttpServerEngine(SecureNetty4HttpServerTransport.this.settings, (HttpServerTransport)SecureNetty4HttpServerTransport.this).orElseGet(SslUtils::createDefaultServerSSLEngine);
            SslHandler sslHandler = new SslHandler(sslEngine);
            ch.pipeline().addFirst("ssl_http", (ChannelHandler)sslHandler);
        }

        @Override
        protected void configurePipeline(Channel ch) {
            ch.pipeline().addLast(new ChannelHandler[]{new Http2OrHttpHandler()});
        }

        private class Http2OrHttpHandler
        extends ApplicationProtocolNegotiationHandler {
            protected Http2OrHttpHandler() {
                super("http/1.1");
            }

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
                if ("h2".equals(protocol)) {
                    SslHttpChannelHandler.this.configureDefaultHttp2Pipeline(ctx.pipeline());
                } else if ("http/1.1".equals(protocol)) {
                    SslHttpChannelHandler.this.configureDefaultHttpPipeline(ctx.pipeline());
                } else {
                    throw new IllegalStateException("Unknown application protocol: " + protocol);
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                super.exceptionCaught(ctx, cause);
                Netty4HttpChannel channel = (Netty4HttpChannel)ctx.channel().attr(Netty4HttpServerTransport.HTTP_CHANNEL_KEY).get();
                if (channel != null) {
                    if (cause instanceof Error) {
                        SecureNetty4HttpServerTransport.this.onException(channel, new Exception(cause));
                    } else {
                        SecureNetty4HttpServerTransport.this.onException(channel, (Exception)cause);
                    }
                }
            }
        }
    }
}

