/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.transport.netty4;

import io.lucenia.transport.Netty4NioSocketChannel;
import io.lucenia.transport.NettyAllocator;
import io.lucenia.transport.NettyByteBufSizer;
import io.lucenia.transport.SharedGroupFactory;
import io.lucenia.transport.netty4.LuceniaLoggingHandler;
import io.lucenia.transport.netty4.Netty4MessageChannelHandler;
import io.lucenia.transport.netty4.Netty4TcpChannel;
import io.lucenia.transport.netty4.Netty4TcpServerChannel;
import io.lucenia.transport.netty4.Netty4Utils;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.util.AttributeKey;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.Version;
import io.skylite.common.SuppressForbidden;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.common.util.net.NetUtils;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.network.NetworkService;
import io.skylite.core.common.unit.ByteSizeUnit;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.common.util.PageCacheRecycler;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TcpTransport;
import io.skylite.core.transport.TransportSettings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.NetworkChannel;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class Netty4Transport
extends TcpTransport {
    private static final Logger logger = LogManager.getLogger(Netty4Transport.class);
    public static final Setting<Integer> WORKER_COUNT = new Setting("transport.netty.worker_count", s -> Integer.toString(SkyliteExecutors.allocatedProcessors((Settings)s)), s -> Setting.parseInt((String)s, (int)1, (String)"transport.netty.worker_count"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_size", (ByteSizeValue)new ByteSizeValue(64L, ByteSizeUnit.KB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_min", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_max", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> NETTY_BOSS_COUNT = Setting.intSetting((String)"transport.netty.boss_count", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final SharedGroupFactory sharedGroupFactory;
    private final RecvByteBufAllocator recvByteBufAllocator;
    private final ByteSizeValue receivePredictorMin;
    private final ByteSizeValue receivePredictorMax;
    private final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();
    private volatile Bootstrap clientBootstrap;
    private volatile SharedGroupFactory.SharedGroup sharedGroup;
    static final AttributeKey<Netty4TcpChannel> CHANNEL_KEY = AttributeKey.newInstance((String)"es-channel");
    static final AttributeKey<Netty4TcpServerChannel> SERVER_CHANNEL_KEY = AttributeKey.newInstance((String)"es-server-channel");

    public Netty4Transport(Settings settings, Version<?> version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, SharedGroupFactory sharedGroupFactory, Tracer tracer) {
        super(settings, version, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService, tracer);
        Netty4Utils.setAvailableProcessors((Integer)SkyliteExecutors.NODE_PROCESSORS_SETTING.get(settings));
        NettyAllocator.logAllocatorDescriptionIfNeeded();
        this.sharedGroupFactory = sharedGroupFactory;
        this.receivePredictorMin = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        this.receivePredictorMax = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.recvByteBufAllocator = this.receivePredictorMax.getBytes() == this.receivePredictorMin.getBytes() ? new FixedRecvByteBufAllocator((int)this.receivePredictorMax.getBytes()) : new AdaptiveRecvByteBufAllocator((int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMax.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            this.sharedGroup = this.sharedGroupFactory.getTransportGroup();
            this.clientBootstrap = this.createClientBootstrap(this.sharedGroup);
            if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue()) {
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    this.createServerBootstrap(profileSettings, this.sharedGroup);
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private Bootstrap createClientBootstrap(SharedGroupFactory.SharedGroup sharedGroup) {
        ByteSizeValue tcpReceiveBufferSize;
        ByteSizeValue tcpSendBufferSize;
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(sharedGroup.getLowLevelGroup());
        assert (Netty4NioSocketChannel.class.isAssignableFrom(NettyAllocator.getChannelType()));
        bootstrap.channel(NettyAllocator.getChannelType());
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)((Boolean)TransportSettings.TCP_NO_DELAY.get(this.settings)));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)((Boolean)TransportSettings.TCP_KEEP_ALIVE.get(this.settings)));
        if (((Boolean)TransportSettings.TCP_KEEP_ALIVE.get(this.settings)).booleanValue()) {
            SocketOption keepCountOption;
            SocketOption keepIntervalOption;
            SocketOption keepIdleOption;
            if ((Integer)TransportSettings.TCP_KEEP_IDLE.get(this.settings) >= 0 && (keepIdleOption = NetUtils.getTcpKeepIdleSocketOptionOrNull()) != null) {
                bootstrap.option(NioChannelOption.of((SocketOption)keepIdleOption), (Object)((Integer)TransportSettings.TCP_KEEP_IDLE.get(this.settings)));
            }
            if ((Integer)TransportSettings.TCP_KEEP_INTERVAL.get(this.settings) >= 0 && (keepIntervalOption = NetUtils.getTcpKeepIntervalSocketOptionOrNull()) != null) {
                bootstrap.option(NioChannelOption.of((SocketOption)keepIntervalOption), (Object)((Integer)TransportSettings.TCP_KEEP_INTERVAL.get(this.settings)));
            }
            if ((Integer)TransportSettings.TCP_KEEP_COUNT.get(this.settings) >= 0 && (keepCountOption = NetUtils.getTcpKeepCountSocketOptionOrNull()) != null) {
                bootstrap.option(NioChannelOption.of((SocketOption)keepCountOption), (Object)((Integer)TransportSettings.TCP_KEEP_COUNT.get(this.settings)));
            }
        }
        if ((tcpSendBufferSize = (ByteSizeValue)TransportSettings.TCP_SEND_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TransportSettings.TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
        }
        bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        boolean reuseAddress = (Boolean)TransportSettings.TCP_REUSE_ADDRESS.get(this.settings);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        return bootstrap;
    }

    private void createServerBootstrap(TcpTransport.ProfileSettings profileSettings, SharedGroupFactory.SharedGroup sharedGroup) {
        String name = profileSettings.profileName;
        if (logger.isDebugEnabled()) {
            logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], receive_predictor[{}->{}]", (Object)name, (Object)this.sharedGroupFactory.getTransportWorkerCount(), (Object)profileSettings.portOrRange, (Object)profileSettings.bindHosts, (Object)profileSettings.publishHosts, (Object)this.receivePredictorMin, (Object)this.receivePredictorMax);
        }
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group(sharedGroup.getLowLevelGroup());
        serverBootstrap.channel(NettyAllocator.getServerChannelType());
        serverBootstrap.option(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
        serverBootstrap.childOption(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
        serverBootstrap.childHandler(this.getServerChannelInitializer(name));
        serverBootstrap.handler((ChannelHandler)new ServerChannelExceptionHandler());
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)profileSettings.tcpNoDelay);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)profileSettings.tcpKeepAlive);
        if (profileSettings.tcpKeepAlive) {
            SocketOption keepCountOption;
            SocketOption keepIntervalOption;
            SocketOption keepIdleOption;
            if (profileSettings.tcpKeepIdle >= 0 && (keepIdleOption = NetUtils.getTcpKeepIdleSocketOptionOrNull()) != null) {
                serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepIdleOption), (Object)profileSettings.tcpKeepIdle);
            }
            if (profileSettings.tcpKeepInterval >= 0 && (keepIntervalOption = NetUtils.getTcpKeepIntervalSocketOptionOrNull()) != null) {
                serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepIntervalOption), (Object)profileSettings.tcpKeepInterval);
            }
            if (profileSettings.tcpKeepCount >= 0 && (keepCountOption = NetUtils.getTcpKeepCountSocketOptionOrNull()) != null) {
                serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepCountOption), (Object)profileSettings.tcpKeepCount);
            }
        }
        if (profileSettings.sendBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(profileSettings.sendBufferSize.getBytes()));
        }
        if (profileSettings.receiveBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(profileSettings.receiveBufferSize.bytesAsInt()));
        }
        serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)profileSettings.reuseAddress);
        serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)profileSettings.reuseAddress);
        serverBootstrap.validate();
        this.serverBootstraps.put(name, serverBootstrap);
    }

    protected ChannelHandler getServerChannelInitializer(String name) {
        return new ServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node) {
        return new ClientChannelInitializer();
    }

    protected Netty4TcpChannel initiateChannel(DiscoveryNode node) throws IOException {
        InetSocketAddress address = node.getAddress().address();
        Bootstrap bootstrapWithHandler = this.clientBootstrap.clone();
        bootstrapWithHandler.handler(this.getClientChannelInitializer(node));
        bootstrapWithHandler.remoteAddress((SocketAddress)address);
        ChannelFuture connectFuture = bootstrapWithHandler.connect();
        Channel channel = connectFuture.channel();
        if (channel == null) {
            SkyliteExceptionsHelper.maybeDieOnAnotherThread((Throwable)connectFuture.cause());
            throw new IOException(connectFuture.cause());
        }
        Netty4TcpChannel nettyChannel = new Netty4TcpChannel(channel, false, "default", connectFuture);
        channel.attr(CHANNEL_KEY).set((Object)nettyChannel);
        return nettyChannel;
    }

    protected Netty4TcpServerChannel bind(String name, InetSocketAddress address) {
        Channel channel = this.serverBootstraps.get(name).bind((SocketAddress)address).syncUninterruptibly().channel();
        Netty4TcpServerChannel esChannel = new Netty4TcpServerChannel(channel);
        channel.attr(SERVER_CHANNEL_KEY).set((Object)esChannel);
        return esChannel;
    }

    @SuppressForbidden(reason="debug")
    protected void stopInternal() {
        Releasable[] releasableArray = new Releasable[3];
        releasableArray[0] = () -> {
            if (this.sharedGroup != null) {
                this.sharedGroup.shutdown();
            }
        };
        releasableArray[1] = this.serverBootstraps::clear;
        releasableArray[2] = () -> {
            this.clientBootstrap = null;
        };
        Releasables.close((Releasable[])releasableArray);
    }

    private void addClosedExceptionLogger(Channel channel) {
        channel.closeFuture().addListener(f -> {
            if (!f.isSuccess()) {
                logger.debug(() -> new ParameterizedMessage("exception while closing channel: {}", (Object)channel), f.cause());
            }
        });
    }

    @ChannelHandler.Sharable
    private class ServerChannelExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private ServerChannelExceptionHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            SkyliteExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            Netty4TcpServerChannel serverChannel = (Netty4TcpServerChannel)ctx.channel().attr(SERVER_CHANNEL_KEY).get();
            if (cause instanceof Error) {
                Netty4Transport.this.onServerException(serverChannel, new Exception(cause));
            } else {
                Netty4Transport.this.onServerException(serverChannel, (Exception)cause);
            }
        }
    }

    protected class ServerChannelInitializer
    extends ChannelInitializer<Channel> {
        protected final String name;
        private final NettyByteBufSizer sizer = new NettyByteBufSizer();

        protected ServerChannelInitializer(String name) {
            this.name = name;
        }

        protected void initChannel(Channel ch) throws Exception {
            Netty4Transport.this.addClosedExceptionLogger(ch);
            assert (ch instanceof Netty4NioSocketChannel);
            NetUtils.tryEnsureReasonableKeepAliveConfig((NetworkChannel)((Netty4NioSocketChannel)ch).javaChannel());
            Netty4TcpChannel nettyTcpChannel = new Netty4TcpChannel(ch, true, this.name, ch.newSucceededFuture());
            ch.attr(CHANNEL_KEY).set((Object)nettyTcpChannel);
            ch.pipeline().addLast("byte_buf_sizer", (ChannelHandler)this.sizer);
            ch.pipeline().addLast("logging", (ChannelHandler)new LuceniaLoggingHandler());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this.pageCacheRecycler, Netty4Transport.this));
            Netty4Transport.this.serverAcceptedChannel(nettyTcpChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            SkyliteExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected class ClientChannelInitializer
    extends ChannelInitializer<Channel> {
        protected ClientChannelInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            Netty4Transport.this.addClosedExceptionLogger(ch);
            assert (ch instanceof Netty4NioSocketChannel);
            NetUtils.tryEnsureReasonableKeepAliveConfig((NetworkChannel)((Netty4NioSocketChannel)ch).javaChannel());
            ch.pipeline().addLast("logging", (ChannelHandler)new LuceniaLoggingHandler());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this.pageCacheRecycler, Netty4Transport.this));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            SkyliteExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

