/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.processor;

import io.skylite.common.CheckedBiFunction;
import io.skylite.common.geometry.Geometry;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.geo.GeometryFormat;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MapXContentParser;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.util.Map;
import org.opensearch.common.geo.GeometryParser;

public interface BaseGeometryIngestProcessor
extends IngestProcessor {
    public String sourceField();

    public String targetField();

    public boolean ignoreMissing();

    public GeometryParser parser();

    public CheckedBiFunction<Geometry, GeometryFormat, Geometry, Exception> processGeometry();

    default public IngestDocument execute(IngestDocument ingestDocument) {
        Object obj = ingestDocument.getFieldValue(this.sourceField(), Object.class, this.ignoreMissing());
        if (obj == null && this.ignoreMissing()) {
            return ingestDocument;
        }
        if (obj == null) {
            throw new IllegalArgumentException("field [" + this.sourceField() + "] is null, cannot process it.");
        }
        if (!(obj instanceof Map) && !(obj instanceof String)) {
            throw new IllegalArgumentException("field [" + this.sourceField() + "] must be a WKT Shape or a GeoJSON Shape value");
        }
        Map<String, Object> valueWrapper = Map.of("shape", obj);
        MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, valueWrapper, MediaTypeRegistry.JSON);
        try {
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            GeometryFormat geometryFormat = this.parser().geometryFormat((XContentParser)parser);
            Geometry inGeometry = (Geometry)geometryFormat.fromXContent((XContentParser)parser);
            Geometry outGeometry = (Geometry)this.processGeometry().apply((Object)inGeometry, (Object)geometryFormat);
            XContentBuilder newValueBuilder = MediaTypeRegistry.JSON.contentBuilder().startObject().field("val");
            geometryFormat.toXContent((Object)outGeometry, newValueBuilder, ToXContent.EMPTY_PARAMS);
            newValueBuilder.endObject();
            Map newObj = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)newValueBuilder), (boolean)true, (MediaType)MediaTypeRegistry.JSON).v2();
            ingestDocument.setFieldValue(this.targetField(), newObj.get("val"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid shape definition", e);
        }
        return ingestDocument;
    }
}

