/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.processor;

import io.lucenia.geo.processor.CircleProcessor;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.ShapeType;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.geo.CircleUtils;
import io.skylite.core.geo.GeometryFormat;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.ingest.IngestDocument;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MapXContentParser;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.util.Map;
import org.opensearch.common.geo.GeometryParser;

public class EllipseProcessor
extends AbstractProcessor
implements IngestProcessor {
    public static final String TYPE = "ellipse";
    private final String field;
    private final String targetField;
    private final boolean ignoreMissing;
    private final double errorDistance;
    private final CircleProcessor.CircleShapeFieldType ellipseShapeFieldType;
    static final GeometryParser PARSER = new GeometryParser(true, true, true);

    EllipseProcessor(String tag, String description, String field, String targetField, boolean ignoreMissing, double errorDistance, CircleProcessor.CircleShapeFieldType ellipseShapeFieldType) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
        this.errorDistance = errorDistance;
        this.ellipseShapeFieldType = ellipseShapeFieldType;
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        Object obj = ingestDocument.getFieldValue(this.field, Object.class, this.ignoreMissing);
        if (obj == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (obj == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        if (!(obj instanceof Map) && !(obj instanceof String)) {
            throw new IllegalArgumentException("field [" + this.field + "] must be a WKT-like Ellipse (e.g., ELLIPSE(centerX centerY semiMajorAxis semiMinorAxis rotationAngle) or a JSON formatted Ellipse.");
        }
        Map<String, Object> valueWrapper = Map.of("shape", obj);
        MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, valueWrapper, MediaTypeRegistry.JSON);
        try {
            Polygon polygon;
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            GeometryFormat geometryFormat = PARSER.geometryFormat((XContentParser)parser);
            Geometry geometry = (Geometry)geometryFormat.fromXContent((XContentParser)parser);
            if (ShapeType.ELLIPSE.equals((Object)geometry.type())) {
                Ellipse ellipse = (Ellipse)geometry;
                int numSides = CircleUtils.ellipseToPolygonNumSides((double)ellipse.getSemiMajorAxisMeters(), (double)ellipse.getSemiMinorAxisMeters(), (double)this.errorDistance);
                switch (this.ellipseShapeFieldType) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case GEO_SHAPE: {
                        polygon = CircleUtils.ellipseToRegularGeoShapePolygon((Ellipse)ellipse, (int)numSides);
                        break;
                    }
                    case SHAPE: {
                        polygon = CircleUtils.createRegularEllipsePolygon((Ellipse)ellipse, (int)numSides);
                    }
                }
            } else {
                throw new IllegalArgumentException("found [" + String.valueOf(geometry.type()) + "] instead of ellipse");
            }
            Polygon polygonizedEllipse = polygon;
            XContentBuilder newValueBuilder = MediaTypeRegistry.JSON.contentBuilder().startObject().field("val");
            geometryFormat.toXContent((Object)polygonizedEllipse, newValueBuilder, ToXContent.EMPTY_PARAMS);
            newValueBuilder.endObject();
            Map newObj = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)newValueBuilder), (boolean)true, (MediaType)XContentType.JSON).v2();
            ingestDocument.setFieldValue(this.targetField, newObj.get("val"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid ellipse definition", e);
        }
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    String field() {
        return this.field;
    }

    String targetField() {
        return this.targetField;
    }

    double errorDistance() {
        return this.errorDistance;
    }

    CircleProcessor.CircleShapeFieldType shapeType() {
        return this.ellipseShapeFieldType;
    }

    public static final class Factory
    implements AbstractProcessor.Factory<EllipseProcessor> {
        public EllipseProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, Map<String, Object> config) {
            String field = ConfigurationUtils.readStringProperty((String)EllipseProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)EllipseProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)field);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)EllipseProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            double radiusDistance = Math.abs(ConfigurationUtils.readDoubleProperty((String)EllipseProcessor.TYPE, (String)processorTag, config, (String)"error_distance"));
            CircleProcessor.CircleShapeFieldType ellipseFieldType = CircleProcessor.CircleShapeFieldType.parse(ConfigurationUtils.readStringProperty((String)EllipseProcessor.TYPE, (String)processorTag, config, (String)"shape_type"));
            return new EllipseProcessor(processorTag, description, field, targetField, ignoreMissing, radiusDistance, ellipseFieldType);
        }
    }
}

