/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.processor.reprojection;

import io.lucenia.geo.processor.BaseGeometryProcessor;
import io.lucenia.geo.processor.reprojection.ReprojectionGeometryVisitor;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.ParseField;
import io.skylite.core.geo.GeometryFormat;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.geographic.referencing.CRSProviderInterface;
import io.skylite.geographic.referencing.CRSProviderRegistry;
import io.skylite.geographic.referencing.GeometryProcessorFieldType;
import java.security.AccessController;
import java.util.Map;
import java.util.Optional;

public abstract class BaseReprojectionProcessor
extends BaseGeometryProcessor {
    public static final ParseField TYPE = new ParseField("reproject", new String[0]);
    private static final CRSProviderInterface DEFAULT_CRS_PROVIDER = CRSProviderRegistry.getDefaultCRSProvider();
    protected final CRSProviderInterface crsProvider;
    private final CRSProviderInterface.CRSHandler<?> crsHandler;
    private final ReprojectionGeometryVisitor reprojector;
    private final double tolerance;
    public static final String DEFAULT_TARGET_CRS = "EPSG:4326";

    protected BaseReprojectionProcessor(String tag, String description, String field, String targetField, boolean ignoreMissing, String fromCRS, String toCRS, double tolerance, GeometryProcessorFieldType shapeFieldType, Optional<String> crsProvider) {
        super(tag, description, field, targetField, ignoreMissing, shapeFieldType);
        this.crsProvider = crsProvider.isPresent() ? CRSProviderRegistry.fromName((String)crsProvider.get()) : DEFAULT_CRS_PROVIDER;
        this.tolerance = tolerance;
        try {
            this.crsHandler = AccessController.doPrivileged(() -> {
                try {
                    return this.crsProvider.createCRSHandler(fromCRS, toCRS, shapeFieldType);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create CRSHandler for projection from [" + fromCRS + "] to [" + toCRS + "]", e);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (this.crsHandler == null) {
            throw new IllegalArgumentException("Unable to reproject from: [" + fromCRS + "] to: [" + toCRS + "]: transform not supported");
        }
        this.reprojector = new ReprojectionGeometryVisitor(this.crsHandler, this.tolerance);
    }

    @Override
    public Geometry processGeometry(Geometry inGeometry, GeometryFormat geometryFormat) throws Exception {
        return (Geometry)inGeometry.visit((GeometryVisitor)this.reprojector);
    }

    public String getType() {
        return TYPE.getPreferredName();
    }

    CRSProviderInterface.CRSHandler<?> getCrsHandler() {
        return this.crsHandler;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public static abstract class Factory<T extends BaseReprojectionProcessor>
    implements AbstractProcessor.Factory<T> {
        public T create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, Map<String, Object> config) {
            String trgtCRS;
            String field = ConfigurationUtils.readStringProperty((String)TYPE.getPreferredName(), (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)TYPE.getPreferredName(), (String)processorTag, config, (String)"target_field", (String)field);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)TYPE.getPreferredName(), (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            String srcCRS = ConfigurationUtils.readOptionalStringProperty((String)TYPE.getPreferredName(), (String)processorTag, config, (String)"source_crs");
            if (srcCRS == null) {
                srcCRS = BaseReprojectionProcessor.DEFAULT_TARGET_CRS;
            }
            if ((trgtCRS = ConfigurationUtils.readOptionalStringProperty((String)TYPE.getPreferredName(), (String)processorTag, config, (String)"target_crs")) == null) {
                trgtCRS = BaseReprojectionProcessor.DEFAULT_TARGET_CRS;
            }
            double tolerance = ConfigurationUtils.readDoubleProperty((String)TYPE.getPreferredName(), (String)processorTag, config, (String)"tolerance", (double)0.01);
            GeometryProcessorFieldType shapeFieldType = GeometryProcessorFieldType.parse((String)ConfigurationUtils.readStringProperty((String)TYPE.getPreferredName(), (String)processorTag, config, (String)"shape_type", (String)GeometryProcessorFieldType.GEO_SHAPE.toString()));
            Optional<String> provider = Optional.ofNullable(ConfigurationUtils.readOptionalStringProperty((String)TYPE.getPreferredName(), (String)processorTag, config, (String)"provider"));
            return this.create(registry, processorTag, description, ignoreMissing, config, field, targetField, srcCRS, trgtCRS, tolerance, shapeFieldType, provider);
        }

        public abstract T create(Map<String, AbstractProcessor.Factory<?>> var1, String var2, String var3, boolean var4, Map<String, Object> var5, String var6, String var7, String var8, String var9, double var10, GeometryProcessorFieldType var12, Optional<String> var13);
    }
}

