/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.processor.reprojection;

import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryCollection;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.MultiLine;
import io.skylite.common.geometry.MultiPoint;
import io.skylite.common.geometry.MultiPolygon;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.geographic.referencing.CRSProviderInterface;
import java.util.ArrayList;

public class ReprojectionGeometryVisitor
implements GeometryVisitor<Geometry, Exception> {
    private CRSProviderInterface.CRSHandler<?> crsHandler;
    private double tolerance;

    public ReprojectionGeometryVisitor(CRSProviderInterface.CRSHandler<?> crsHandler, double tolerance) {
        this.crsHandler = crsHandler;
        this.tolerance = tolerance;
    }

    public Geometry visit(Circle circle) throws RuntimeException {
        throw new IllegalArgumentException("invalid shape type found [Circle] while reprojecting shape");
    }

    public Geometry visit(Ellipse ellipse) throws RuntimeException {
        throw new IllegalArgumentException("invalid shape type found [Ellipse] while reprojecting shape");
    }

    public Geometry visit(GeometryCollection<?> collection) throws Exception {
        ArrayList<Geometry> reprojectedGeometry = new ArrayList<Geometry>(collection.size());
        for (Geometry geometry : collection) {
            reprojectedGeometry.add((Geometry)geometry.visit((GeometryVisitor)this));
        }
        return new GeometryCollection(reprojectedGeometry);
    }

    public Line visit(Line line) throws Exception {
        double[][] vertices = ReprojectionGeometryVisitor.reprojectVertices(line.getX(), line.getY(), this.crsHandler, this.tolerance);
        return new Line(vertices[0], vertices[1]);
    }

    public LinearRing visit(LinearRing ring) throws Exception {
        double[][] vertices = ReprojectionGeometryVisitor.reprojectVertices(ring.getX(), ring.getY(), this.crsHandler, this.tolerance);
        return new LinearRing(vertices[0], vertices[1]);
    }

    public MultiLine visit(MultiLine multiLine) throws Exception {
        ArrayList<Line> lines = new ArrayList<Line>(multiLine.size());
        for (Line line : multiLine.getAll()) {
            lines.add(this.visit(line));
        }
        return new MultiLine(lines);
    }

    public MultiPoint visit(MultiPoint multiPoint) throws Exception {
        ArrayList<Point> points = new ArrayList<Point>(multiPoint.size());
        for (int i = 0; i < multiPoint.size(); ++i) {
            points.add(this.visit((Point)multiPoint.get(i)));
        }
        return new MultiPoint(points);
    }

    public MultiPolygon visit(MultiPolygon multiPolygon) throws Exception {
        ArrayList<Polygon> polys = new ArrayList<Polygon>(multiPolygon.size());
        for (int i = 0; i < multiPolygon.size(); ++i) {
            polys.add(this.visit((Polygon)multiPolygon.get(i)));
        }
        return new MultiPolygon(polys);
    }

    public Point visit(Point point) throws Exception {
        double[] buffer = new double[]{point.getX(), point.getY()};
        this.crsHandler.reproject(buffer, buffer, this.tolerance);
        return new Point(buffer[0], buffer[1]);
    }

    public Polygon visit(Polygon polygon) throws Exception {
        LinearRing shell = this.visit(polygon.getPolygon());
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>(polygon.getNumberOfHoles());
        for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
            holes.add(this.visit(polygon.getHole(i)));
        }
        return new Polygon(shell, holes);
    }

    public Rectangle visit(Rectangle rectangle) throws Exception {
        double[] buffer = new double[]{rectangle.getMinX(), rectangle.getMinY()};
        this.crsHandler.reproject(buffer, buffer, this.tolerance);
        double minX = buffer[0];
        double minY = buffer[1];
        buffer[0] = rectangle.getMaxX();
        buffer[1] = rectangle.getMaxY();
        this.crsHandler.reproject(buffer, buffer, this.tolerance);
        double maxX = buffer[0];
        double maxY = buffer[1];
        return new Rectangle(minX, maxX, maxY, minY);
    }

    private static double[][] reprojectVertices(double[] x, double[] y, CRSProviderInterface.CRSHandler<?> crsHandler, double tolerance) throws Exception {
        double[][] result = new double[2][x.length];
        double[] buffer = new double[2];
        for (int i = 0; i < x.length; ++i) {
            buffer[0] = x[i];
            buffer[1] = y[i];
            crsHandler.reproject(buffer, buffer, tolerance);
            result[0][i] = buffer[0];
            result[1][i] = buffer[1];
        }
        return result;
    }
}

