/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.processor.reprojection;

import io.lucenia.geo.processor.BaseGeometrySearchProcessor;
import io.lucenia.geo.processor.reprojection.BaseReprojectionProcessor;
import io.lucenia.geo.search.query.ShapeQueryBuilder;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.index.query.CheckedQueryBuilderVisitor;
import io.skylite.core.index.query.CheckedQueryShapeVisitor;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.pipeline.SearchProcessor;
import io.skylite.core.search.pipeline.SearchRequestProcessor;
import io.skylite.geographic.referencing.CRSProviderInterface;
import io.skylite.geographic.referencing.GeometryProcessorFieldType;
import java.util.Map;
import java.util.Optional;
import org.opensearch.common.geo.GeometryParser;
import org.opensearch.index.query.AbstractGeometryQueryBuilder;
import org.opensearch.index.query.GeoBoundingBoxQueryBuilder;
import org.opensearch.index.query.GeoShapeQueryBuilder;

public class ReprojectionSearchRequestProcessor
extends BaseReprojectionProcessor
implements BaseGeometrySearchProcessor,
SearchRequestProcessor {
    protected ReprojectionSearchRequestProcessor(String tag, String description, String field, String targetField, boolean ignoreMissing, String fromCRS, String toCRS, double tolerance, GeometryProcessorFieldType shapeFieldType, Optional<String> crsProvider) {
        super(tag, description, field, targetField, ignoreMissing, fromCRS, toCRS, tolerance, shapeFieldType, crsProvider);
    }

    @Override
    public String sourceField() {
        return this.sourceField;
    }

    @Override
    public String targetField() {
        return this.targetField;
    }

    @Override
    public boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    public GeometryParser parser() {
        return PARSER;
    }

    public SearchRequest processRequest(SearchRequest request) throws Exception {
        if (request == null || request.source() == null) {
            throw new IllegalArgumentException("failure processing reprojection search request processor [" + this.tag + "] search request must not be null");
        }
        QueryBuilder qb = request.source().query();
        ReprojectionQueryVisitor reprojectionVisitor = new ReprojectionQueryVisitor();
        qb.visit((CheckedQueryBuilderVisitor)reprojectionVisitor);
        request.source().query(qb);
        return request;
    }

    protected class ReprojectionQueryVisitor
    extends CheckedQueryShapeVisitor<ReprojectionQueryVisitor, QueryBuilder, Exception> {
        private final CRSProviderInterface.CRSHandler<?> crsHandler;
        private double[] from = new double[2];
        private double[] to = new double[2];

        protected ReprojectionQueryVisitor() {
            this.crsHandler = ReprojectionSearchRequestProcessor.this.getCrsHandler();
        }

        public QueryBuilder visit(QueryBuilder qb) throws Exception {
            if (qb instanceof GeoShapeQueryBuilder || qb instanceof ShapeQueryBuilder) {
                return this.handleShapeQuery((AbstractGeometryQueryBuilder)qb);
            }
            if (qb instanceof GeoBoundingBoxQueryBuilder) {
                return this.handleGeoBoundingBoxQuery((GeoBoundingBoxQueryBuilder)qb);
            }
            return qb;
        }

        protected ReprojectionQueryVisitor newInstance() {
            return new ReprojectionQueryVisitor();
        }

        private QueryBuilder handleGeoBoundingBoxQuery(GeoBoundingBoxQueryBuilder bboxQuery) throws Exception {
            GeoPoint tl = bboxQuery.topLeft();
            this.from[0] = tl.getLon();
            this.from[1] = tl.getLat();
            this.crsHandler.reproject(this.from, this.to, ReprojectionSearchRequestProcessor.this.getTolerance());
            tl.reset(this.to[0], this.to[1]);
            GeoPoint br = bboxQuery.bottomRight();
            this.from[0] = br.getLon();
            this.from[1] = br.getLat();
            this.crsHandler.reproject(this.from, this.to, ReprojectionSearchRequestProcessor.this.getTolerance());
            br.reset(this.to[0], this.to[1]);
            return bboxQuery;
        }

        private QueryBuilder handleShapeQuery(AbstractGeometryQueryBuilder<?> shapeQuery) throws Exception {
            Geometry shape = shapeQuery.shape();
            Geometry reprojectedShape = ReprojectionSearchRequestProcessor.this.processGeometry(shape, null);
            shapeQuery.shape(reprojectedShape);
            return shapeQuery;
        }
    }

    public static final class Factory
    extends BaseReprojectionProcessor.Factory<ReprojectionSearchRequestProcessor>
    implements SearchProcessor.Factory<ReprojectionSearchRequestProcessor> {
        @Override
        public ReprojectionSearchRequestProcessor create(Map<String, AbstractProcessor.Factory<?>> registry, String processorTag, String description, boolean ignoreMissing, Map<String, Object> config, String field, String targetField, String srcCRS, String trgtCRS, double tolerance, GeometryProcessorFieldType shapeFieldType, Optional<String> provider) {
            return new ReprojectionSearchRequestProcessor(processorTag, description, field, targetField, ignoreMissing, srcCRS, trgtCRS, tolerance, shapeFieldType, provider);
        }

        public ReprojectionSearchRequestProcessor create(Map<String, SearchProcessor.Factory<ReprojectionSearchRequestProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, SearchProcessor.PipelineContext pipelineContext) throws Exception {
            return (ReprojectionSearchRequestProcessor)this.create(null, tag, description, config);
        }
    }
}

