/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.aggregations.bucket.composite;

import io.lucenia.geo.search.aggregations.bucket.composite.GeoTileValuesSource;
import io.lucenia.geo.search.aggregations.bucket.geogrid.cells.CellIdSource;
import io.skylite.common.CheckedFunction;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.values.GeoPointValuesSource;
import io.skylite.core.aggregations.values.GeoValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.geo.DocValueGeoFormatters;
import io.skylite.core.geo.GeoBoundingBox;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.geo.GeoTileUtils;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;

public class GeoTileGridValuesSourceBuilder
extends CompositeValuesSourceBuilder<GeoTileGridValuesSourceBuilder> {
    public static final String TYPE = "geotile_grid";
    @Deprecated
    public static final Byte COMPOSITE_AGGREGATION_SERIALISATION_BYTE_CODE = 3;
    static final AggregationRegistry.RegistryKey<GeoTileCompositeSuppier> REGISTRY_KEY = new AggregationRegistry.RegistryKey("geotile_grid", GeoTileCompositeSuppier.class);
    static final ObjectParser<GeoTileGridValuesSourceBuilder, Void> PARSER = new ObjectParser("geotile_grid");
    private int precision = 7;
    private GeoBoundingBox geoBoundingBox = new GeoBoundingBox(new GeoPoint(Double.NaN, Double.NaN), new GeoPoint(Double.NaN, Double.NaN));

    public static GeoTileGridValuesSourceBuilder parse(String name, XContentParser parser) throws IOException {
        return (GeoTileGridValuesSourceBuilder)((Object)PARSER.parse(parser, (Object)new GeoTileGridValuesSourceBuilder(name), null));
    }

    public static void register(AggregationRegistry.Builder builder) {
        builder.register(REGISTRY_KEY, (ValuesSourceType)GeoValuesSourceType.GEOPOINT, (valuesSourceConfig, precision, boundingBox, name, hasScript, format, missingBucket, missingOrder, order) -> {
            GeoPointValuesSource geoPoint = (GeoPointValuesSource)valuesSourceConfig.getValuesSource();
            MappedFieldType fieldType = valuesSourceConfig.fieldType();
            CellIdSource cellIdSource = new CellIdSource(geoPoint, precision, boundingBox, GeoTileUtils::longEncode);
            return new CompositeValuesSourceConfig(name, fieldType, (ValuesSource)cellIdSource, DocValueGeoFormatters.GEOTILE, order, missingBucket, missingOrder, hasScript, (bigArrays, reader, size, addRequestCircuitBreakerBytes, compositeValuesSourceConfig) -> {
                CellIdSource cis = (CellIdSource)compositeValuesSourceConfig.valuesSource();
                return new GeoTileValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), (CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException>)((CheckedFunction)cis::longValues), LongUnaryOperator.identity(), compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
            });
        }, false);
    }

    GeoTileGridValuesSourceBuilder(String name) {
        super(name);
    }

    public GeoTileGridValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
        this.precision = in.readInt();
        this.geoBoundingBox = new GeoBoundingBox(in);
    }

    public GeoTileGridValuesSourceBuilder precision(int precision) {
        this.precision = GeoTileUtils.checkPrecisionRange((int)precision);
        return this;
    }

    public GeoTileGridValuesSourceBuilder geoBoundingBox(GeoBoundingBox geoBoundingBox) {
        this.geoBoundingBox = geoBoundingBox;
        return this;
    }

    public GeoTileGridValuesSourceBuilder format(String format) {
        throw new IllegalArgumentException("[format] is not supported for [geotile_grid]");
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeInt(this.precision);
        this.geoBoundingBox.writeTo(out);
    }

    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("precision", this.precision);
        if (!this.geoBoundingBox.isUnbounded()) {
            this.geoBoundingBox.toXContent(builder, params);
        }
    }

    protected String type() {
        return TYPE;
    }

    GeoBoundingBox geoBoundingBox() {
        return this.geoBoundingBox;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.geoBoundingBox);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GeoTileGridValuesSourceBuilder other = (GeoTileGridValuesSourceBuilder)((Object)obj);
        return Objects.equals(this.precision, other.precision) && Objects.equals(this.geoBoundingBox, other.geoBoundingBox);
    }

    protected ValuesSourceType getDefaultValuesSourceType() {
        return GeoValuesSourceType.GEOPOINT;
    }

    protected CompositeValuesSourceConfig innerBuild(AggregationRegistry registry, ValuesSourceConfig config) throws IOException {
        return ((GeoTileCompositeSuppier)registry.getAggregator(REGISTRY_KEY, config)).apply(config, this.precision, this.geoBoundingBox(), this.name, this.script() != null, this.format(), this.missingBucket(), this.missingOrder(), this.order());
    }

    static {
        PARSER.declareInt(GeoTileGridValuesSourceBuilder::precision, new ParseField("precision", new String[0]));
        PARSER.declareField((p, builder, context) -> builder.geoBoundingBox(GeoBoundingBox.parseBoundingBox((XContentParser)p)), GeoBoundingBox.BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER);
    }

    @FunctionalInterface
    public static interface GeoTileCompositeSuppier {
        public CompositeValuesSourceConfig apply(ValuesSourceConfig var1, int var2, GeoBoundingBox var3, String var4, boolean var5, String var6, boolean var7, MissingOrder var8, SortOrder var9);
    }
}

