/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.aggregations.bucket.geogrid;

import io.lucenia.geo.search.aggregations.bucket.geogrid.BaseGeoGrid;
import io.lucenia.geo.search.aggregations.bucket.geogrid.BaseGeoGridBucket;
import io.lucenia.geo.search.aggregations.bucket.geogrid.BucketPriorityQueue;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.bucket.terms.LongKeyedBucketOrds;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;

public abstract class GeoGridAggregator<T extends BaseGeoGrid>
extends BucketsAggregator {
    protected final int requiredSize;
    protected final int shardSize;
    protected final NumericValuesSource valuesSource;
    protected final LongKeyedBucketOrds bucketOrds;

    protected GeoGridAggregator(String name, AggregatorFactories factories, NumericValuesSource valuesSource, int requiredSize, int shardSize, SearchExecutionContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, CardinalityUpperBound.MANY, metadata);
        this.valuesSource = valuesSource;
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.bucketOrds = LongKeyedBucketOrds.build((BigArrays)this.context.bigArrays(), (CardinalityUpperBound)cardinality);
    }

    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        return new LeafBucketCollectorBase(sub, null){

            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        long bucketOrdinal = GeoGridAggregator.this.bucketOrds.add(owningBucketOrd, val);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                            GeoGridAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                        } else {
                            GeoGridAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                        }
                        previous = val;
                    }
                }
            }
        };
    }

    protected abstract T buildAggregation(String var1, int var2, List<BaseGeoGridBucket> var3, Map<String, Object> var4);

    protected abstract BaseGeoGridBucket newEmptyBucket();

    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        Object[][] topBucketsPerOrd = new BaseGeoGridBucket[owningBucketOrds.length][];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            int size = (int)Math.min(this.bucketOrds.bucketsInOrd(owningBucketOrds[ordIdx]), (long)this.shardSize);
            BucketPriorityQueue ordered = new BucketPriorityQueue(size);
            BaseGeoGridBucket spare = null;
            LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            while (ordsEnum.next()) {
                if (spare == null) {
                    spare = this.newEmptyBucket();
                }
                spare.hashAsLong = ordsEnum.value();
                spare.docCount = this.bucketDocCount(ordsEnum.ord());
                spare.bucketOrd = ordsEnum.ord();
                spare = (BaseGeoGridBucket)ordered.insertWithOverflow(spare);
            }
            topBucketsPerOrd[ordIdx] = new BaseGeoGridBucket[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                topBucketsPerOrd[ordIdx][i] = (BaseGeoGridBucket)ordered.pop();
            }
        }
        this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, aggs) -> {
            b.aggregations = aggs;
        });
        InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            results[ordIdx] = this.buildAggregation(this.name, this.requiredSize, Arrays.asList(topBucketsPerOrd[ordIdx]), this.metadata());
        }
        return results;
    }

    public BaseGeoGrid buildEmptyAggregation() {
        return this.buildAggregation(this.name, this.requiredSize, Collections.emptyList(), this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }
}

