/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.aggregations.bucket.geogrid;

import io.lucenia.geo.search.aggregations.bucket.geogrid.GeoGridAggregatorSupplier;
import io.lucenia.geo.search.aggregations.bucket.geogrid.GeoTileGrid;
import io.lucenia.geo.search.aggregations.bucket.geogrid.GeoTileGridAggregationBuilder;
import io.lucenia.geo.search.aggregations.bucket.geogrid.GeoTileGridAggregator;
import io.lucenia.geo.search.aggregations.bucket.geogrid.cells.CellIdSource;
import io.lucenia.geo.search.aggregations.bucket.geogrid.cells.GeoShapeCellIdSource;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.values.GeoPointValuesSource;
import io.skylite.core.aggregations.values.GeoShapeValuesSource;
import io.skylite.core.aggregations.values.GeoValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.geo.GeoBoundingBox;
import io.skylite.core.geo.GeoTileUtils;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

class GeoTileGridAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int precision;
    private final int requiredSize;
    private final int shardSize;
    private final GeoBoundingBox geoBoundingBox;

    GeoTileGridAggregatorFactory(String name, ValuesSourceConfig config, int precision, int requiredSize, int shardSize, GeoBoundingBox geoBoundingBox, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.precision = precision;
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.geoBoundingBox = geoBoundingBox;
    }

    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        GeoTileGrid aggregation = new GeoTileGrid(this.name, this.requiredSize, Collections.emptyList(), metadata);
        return new NonCollectingAggregator(this, this.name, searchContext, parent, this.factories, metadata, (InternalAggregation)aggregation){
            final /* synthetic */ InternalAggregation val$aggregation;
            {
                this.val$aggregation = internalAggregation;
                super(arg0, arg1, arg2, arg3, arg4);
            }

            public InternalAggregation buildEmptyAggregation() {
                return this.val$aggregation;
            }
        };
    }

    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return ((GeoGridAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(GeoTileGridAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.factories, this.config.getValuesSource(), this.precision, this.geoBoundingBox, this.requiredSize, this.shardSize, searchContext, parent, cardinality, metadata);
    }

    static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(GeoTileGridAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoValuesSourceType.GEOPOINT, (name, factories, valuesSource, precision, geoBoundingBox, requiredSize, shardSize, aggregationContext, parent, cardinality, metadata) -> {
            CellIdSource cellIdSource = new CellIdSource((GeoPointValuesSource)valuesSource, precision, geoBoundingBox, GeoTileUtils::longEncode);
            return new GeoTileGridAggregator(name, factories, cellIdSource, requiredSize, shardSize, aggregationContext, parent, cardinality, metadata);
        }, true);
        builder.register(GeoTileGridAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)GeoValuesSourceType.GEO_SHAPE, (name, factories, valuesSource, precision, geoBoundingBox, requiredSize, shardSize, aggregationContext, parent, cardinality, metadata) -> {
            GeoShapeCellIdSource cellIdSource = new GeoShapeCellIdSource((GeoShapeValuesSource)valuesSource, precision, geoBoundingBox, GeoTileUtils::encodeShape);
            return new GeoTileGridAggregator(name, factories, cellIdSource, requiredSize, shardSize, aggregationContext, parent, cardinality, metadata);
        }, true);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

