/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.aggregations.bucket.geogrid.cells;

import io.lucenia.geo.search.aggregations.bucket.geogrid.cells.GeoShapeCellIdSource;
import io.skylite.common.geometry.Rectangle;
import io.skylite.core.geo.GeoBoundingBox;
import io.skylite.core.geo.GeoShapeDocValue;
import io.skylite.core.index.fielddata.AbstractSortingNumericDocValues;
import io.skylite.core.index.fielddata.geo.GeoShapeValue;
import java.io.IOException;
import java.util.List;

abstract class GeoShapeCellValues
extends AbstractSortingNumericDocValues {
    private final GeoShapeValue geoShapeValue;
    protected int precision;
    protected final GeoShapeCellIdSource.GeoShapeLongEncoder encoder;

    public GeoShapeCellValues(GeoShapeValue geoShapeValue, int precision, GeoShapeCellIdSource.GeoShapeLongEncoder encoder) {
        this.geoShapeValue = geoShapeValue;
        this.precision = precision;
        this.encoder = encoder;
    }

    public boolean advanceExact(int docId) throws IOException {
        if (this.geoShapeValue.advanceExact(docId)) {
            GeoShapeDocValue geoShapeDocValue = this.geoShapeValue.nextValue();
            this.relateShape(geoShapeDocValue);
            this.sort();
            return true;
        }
        return false;
    }

    abstract void relateShape(GeoShapeDocValue var1);

    static class UnboundedCellValues
    extends GeoShapeCellValues {
        public UnboundedCellValues(GeoShapeValue geoShapeValue, int precision, GeoShapeCellIdSource.GeoShapeLongEncoder encoder) {
            super(geoShapeValue, precision, encoder);
        }

        @Override
        void relateShape(GeoShapeDocValue geoShapeDocValue) {
            List<Long> encodedValues = this.encoder.encode(geoShapeDocValue, this.precision);
            this.resize(encodedValues.size());
            for (int i = 0; i < encodedValues.size(); ++i) {
                this.values[i] = encodedValues.get(i);
            }
        }
    }

    static class BoundedCellValues
    extends GeoShapeCellValues {
        private final Rectangle geoBoundingBox;

        public BoundedCellValues(GeoShapeValue geoShapeValue, int precision, GeoShapeCellIdSource.GeoShapeLongEncoder encoder, GeoBoundingBox boundingBox) {
            super(geoShapeValue, precision, encoder);
            this.geoBoundingBox = new Rectangle(boundingBox.left(), boundingBox.right(), boundingBox.top(), boundingBox.bottom());
        }

        @Override
        void relateShape(GeoShapeDocValue geoShapeDocValue) {
            if (geoShapeDocValue.isIntersectingRectangle(this.geoBoundingBox)) {
                List<Long> encodedValues = this.encoder.encode(geoShapeDocValue, this.precision);
                this.resize(encodedValues.size());
                for (int i = 0; i < encodedValues.size(); ++i) {
                    this.values[i] = encodedValues.get(i);
                }
            } else {
                this.resize(0);
            }
        }
    }
}

