/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.aggregations.metrics;

import io.lucenia.geo.search.aggregations.metrics.AbstractGeoBoundsAggregator;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.GeoPointValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.index.fielddata.geo.MultiGeoPointValues;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;

final class GeoBoundsAggregator
extends AbstractGeoBoundsAggregator<GeoPointValuesSource> {
    GeoBoundsAggregator(String name, SearchExecutionContext aggregationContext, Aggregator parent, ValuesSourceConfig valuesSourceConfig, boolean wrapLongitude, Map<String, Object> metadata) throws IOException {
        super(name, aggregationContext, parent, valuesSourceConfig, wrapLongitude, metadata);
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final MultiGeoPointValues values = ((GeoPointValuesSource)this.valuesSource).geoPointValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                GeoBoundsAggregator.this.setBucketSize(bucket, bigArrays);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    for (int i = 0; i < valuesCount; ++i) {
                        GeoPoint value = values.nextValue();
                        double top = GeoBoundsAggregator.this.tops.get(bucket);
                        if (value.lat() > top) {
                            top = value.lat();
                        }
                        double bottom = GeoBoundsAggregator.this.bottoms.get(bucket);
                        if (value.lat() < bottom) {
                            bottom = value.lat();
                        }
                        double posLeft = GeoBoundsAggregator.this.posLefts.get(bucket);
                        if (value.lon() >= 0.0 && value.lon() < posLeft) {
                            posLeft = value.lon();
                        }
                        double posRight = GeoBoundsAggregator.this.posRights.get(bucket);
                        if (value.lon() >= 0.0 && value.lon() > posRight) {
                            posRight = value.lon();
                        }
                        double negLeft = GeoBoundsAggregator.this.negLefts.get(bucket);
                        if (value.lon() < 0.0 && value.lon() < negLeft) {
                            negLeft = value.lon();
                        }
                        double negRight = GeoBoundsAggregator.this.negRights.get(bucket);
                        if (value.lon() < 0.0 && value.lon() > negRight) {
                            negRight = value.lon();
                        }
                        GeoBoundsAggregator.this.tops.set(bucket, top);
                        GeoBoundsAggregator.this.bottoms.set(bucket, bottom);
                        GeoBoundsAggregator.this.posLefts.set(bucket, posLeft);
                        GeoBoundsAggregator.this.posRights.set(bucket, posRight);
                        GeoBoundsAggregator.this.negLefts.set(bucket, negLeft);
                        GeoBoundsAggregator.this.negRights.set(bucket, negRight);
                    }
                }
            }
        };
    }
}

