/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.search.query;

import io.skylite.common.geometry.Geometry;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.common.geo.parsers.ShapeParser;
import org.opensearch.index.mapper.ShapeQueryable;
import org.opensearch.index.query.AbstractGeometryQueryBuilder;

public class ShapeQueryBuilder
extends AbstractGeometryQueryBuilder<ShapeQueryBuilder> {
    public static final String NAME = "shape";

    @Deprecated
    public ShapeQueryBuilder(String fieldName, ShapeBuilder shape) {
        super(fieldName, shape);
    }

    public ShapeQueryBuilder(String fieldName, Geometry shape) {
        super(fieldName, shape);
    }

    protected ShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId) {
        super(fieldName, shapeSupplier, indexedShapeId);
    }

    public ShapeQueryBuilder(String fieldName, String indexedShapeId) {
        super(fieldName, indexedShapeId);
    }

    public ShapeQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
    }

    protected boolean doEquals(ShapeQueryBuilder other) {
        return super.doEquals((AbstractGeometryQueryBuilder)AbstractGeometryQueryBuilder.class.cast((Object)other));
    }

    protected int doHashCode() {
        return Objects.hash(super.doHashCode());
    }

    protected Query buildShapeQuery(QueryShardContext context, MappedFieldType fieldType) {
        if (!(fieldType instanceof ShapeQueryable)) {
            throw new QueryShardException(context.index(), "Field [" + this.fieldName + "] is of unsupported type [" + fieldType.typeName() + "] for [shape] query.", new Object[0]);
        }
        ShapeQueryable sq = (ShapeQueryable)fieldType;
        return new ConstantScoreQuery(sq.shapeQuery(this.shape, fieldType.name(), this.relation, context));
    }

    protected void doShapeQueryXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    protected ShapeQueryBuilder newShapeQueryBuilder(String fieldName, Geometry shape) {
        return new ShapeQueryBuilder(fieldName, shape);
    }

    protected ShapeQueryBuilder newShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId) {
        return new ShapeQueryBuilder(fieldName, shapeSupplier, indexedShapeId);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected ShapeQueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        return (ShapeQueryBuilder)super.doRewrite(queryRewriteContext);
    }

    public static ShapeQueryBuilder fromXContent(XContentParser parser) throws IOException {
        ParsedShapeQueryParams psqp = (ParsedShapeQueryParams)AbstractGeometryQueryBuilder.parsedParamsFromXContent((XContentParser)parser, (AbstractGeometryQueryBuilder.ParsedGeometryQueryParams)new ParsedShapeQueryParams());
        ShapeQueryBuilder builder = psqp.shape != null ? new ShapeQueryBuilder(psqp.fieldName, psqp.shape) : new ShapeQueryBuilder(psqp.fieldName, psqp.id);
        if (psqp.index != null) {
            builder.indexedShapeIndex(psqp.index);
        }
        if (psqp.shapePath != null) {
            builder.indexedShapePath(psqp.shapePath);
        }
        if (psqp.shapeRouting != null) {
            builder.indexedShapeRouting(psqp.shapeRouting);
        }
        if (psqp.relation != null) {
            builder.relation(psqp.relation);
        }
        if (psqp.queryName != null) {
            builder.queryName(psqp.queryName);
        }
        builder.boost(psqp.boost);
        builder.ignoreUnmapped(psqp.ignoreUnmapped);
        return builder;
    }

    private static class ParsedShapeQueryParams
    extends AbstractGeometryQueryBuilder.ParsedGeometryQueryParams {
        private ParsedShapeQueryParams() {
        }

        protected boolean parseXContentField(XContentParser parser) throws IOException {
            if (SHAPE_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
                this.shape = ShapeParser.parse((XContentParser)parser);
                return true;
            }
            return false;
        }
    }
}

