/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.geo.util;

import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Ellipse;
import io.skylite.common.geometry.Geometry;
import io.skylite.common.geometry.GeometryCollection;
import io.skylite.common.geometry.GeometryVisitor;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.LinearRing;
import io.skylite.common.geometry.MultiLine;
import io.skylite.common.geometry.MultiPoint;
import io.skylite.common.geometry.MultiPolygon;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.common.geometry.ShapeType;
import io.skylite.core.geo.ShapeRelation;
import io.skylite.core.geo.ShapeUtils;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.XYEllipse;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;

public class ShapeQueryUtils {
    public static XYEllipse toLuceneXYEllipse(Ellipse ellipse) {
        return new XYEllipse((float)ellipse.getX(), (float)ellipse.getY(), (float)ellipse.getSemiMajorAxisMeters(), (float)ellipse.getSemiMinorAxisMeters(), (float)ellipse.getOrientationDegrees());
    }

    public static Query toXYShapeQuery(Geometry geometry, String fieldName, ShapeRelation relation, boolean indexed) {
        assert (indexed);
        if (geometry == null || geometry.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        XYGeometry[] luceneGeometries = ShapeQueryUtils.toXYGeometry(geometry, t -> {});
        return XYShape.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (XYGeometry[])luceneGeometries);
    }

    public static XYGeometry[] toXYGeometry(Geometry geometry, final Consumer<ShapeType> checker) {
        if (geometry == null || geometry.isEmpty()) {
            return new XYGeometry[0];
        }
        final ArrayList geometries = new ArrayList();
        geometry.visit((GeometryVisitor)new GeometryVisitor<Object, RuntimeException>(){

            public Void visit(Circle circle) {
                checker.accept(ShapeType.CIRCLE);
                if (!circle.isEmpty()) {
                    geometries.add(ShapeUtils.toLuceneXYCircle((Circle)circle));
                }
                return null;
            }

            public Void visit(Ellipse ellipse) {
                checker.accept(ShapeType.ELLIPSE);
                if (!ellipse.isEmpty()) {
                    geometries.add(ShapeQueryUtils.toLuceneXYEllipse(ellipse));
                }
                return null;
            }

            public Void visit(GeometryCollection<?> collection) {
                checker.accept(ShapeType.GEOMETRYCOLLECTION);
                if (!collection.isEmpty()) {
                    for (Geometry shape : collection) {
                        shape.visit((GeometryVisitor)this);
                    }
                }
                return null;
            }

            public Void visit(Line line) {
                checker.accept(ShapeType.LINESTRING);
                if (!line.isEmpty()) {
                    geometries.add(ShapeUtils.toLuceneXYLine((Line)line));
                }
                return null;
            }

            public Void visit(LinearRing ring) {
                throw new IllegalArgumentException("Found an unsupported shape LinearRing");
            }

            public Void visit(MultiLine multiLine) {
                checker.accept(ShapeType.MULTILINESTRING);
                if (!multiLine.isEmpty()) {
                    for (Line line : multiLine) {
                        this.visit(line);
                    }
                }
                return null;
            }

            public Void visit(MultiPoint multiPoint) {
                checker.accept(ShapeType.MULTIPOINT);
                if (!multiPoint.isEmpty()) {
                    for (Point point : multiPoint) {
                        this.visit(point);
                    }
                }
                return null;
            }

            public Void visit(MultiPolygon multiPolygon) {
                checker.accept(ShapeType.MULTIPOLYGON);
                if (!multiPolygon.isEmpty()) {
                    for (Polygon polygon : multiPolygon) {
                        this.visit(polygon);
                    }
                }
                return null;
            }

            public Void visit(Point point) {
                checker.accept(ShapeType.POINT);
                if (!point.isEmpty()) {
                    geometries.add(ShapeUtils.toLuceneXYPoint((Point)point));
                }
                return null;
            }

            public Void visit(Polygon polygon) {
                checker.accept(ShapeType.POLYGON);
                if (!polygon.isEmpty()) {
                    geometries.add(ShapeUtils.toLuceneXYPolygon((Polygon)polygon));
                }
                return null;
            }

            public Void visit(Rectangle r) {
                checker.accept(ShapeType.ENVELOPE);
                if (!r.isEmpty()) {
                    geometries.add(ShapeUtils.toLuceneXYRectangle((Rectangle)r));
                }
                return null;
            }
        });
        return geometries.toArray(new XYGeometry[0]);
    }
}

