/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Objects;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.Ellipse2D;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.LatLonGeometry;

public class Ellipse
extends LatLonGeometry {
    private final double lat;
    private final double lon;
    private final double semiMajorAxisMeters;
    private final double semiMinorAxisMeters;
    private final double orientationDegrees;

    public Ellipse(double lat, double lon, double semiMajorAxisMeters, double semiMinorAxisMeters, double orientationDegrees) {
        GeoUtils.checkLatitude((double)lat);
        GeoUtils.checkLongitude((double)lon);
        if (!Double.isFinite(semiMajorAxisMeters) || semiMajorAxisMeters < 0.0) {
            throw new IllegalArgumentException("semiMajorAxisMeters: '" + semiMajorAxisMeters + "' is invalid");
        }
        if (!Double.isFinite(semiMinorAxisMeters) || semiMinorAxisMeters < 0.0) {
            throw new IllegalArgumentException("semiMinorAxisMeters: '" + semiMinorAxisMeters + "' is invalid");
        }
        if (!Double.isFinite(orientationDegrees) || orientationDegrees < 0.0) {
            throw new IllegalArgumentException("orientationDegrees: '" + orientationDegrees + "' is invalid");
        }
        this.lat = lat;
        this.lon = lon;
        this.semiMajorAxisMeters = semiMajorAxisMeters;
        this.semiMinorAxisMeters = semiMinorAxisMeters;
        this.orientationDegrees = orientationDegrees;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getSemiMajorAxisMeters() {
        return this.semiMajorAxisMeters;
    }

    public double getSemiMinorAxisMeters() {
        return this.semiMinorAxisMeters;
    }

    public double getOrientationDegrees() {
        return this.orientationDegrees;
    }

    protected Component2D toComponent2D() {
        return Ellipse2D.create(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Ellipse ellipse = (Ellipse)((Object)o);
        return Double.compare(this.lat, ellipse.lat) == 0 && Double.compare(this.lon, ellipse.lon) == 0 && Double.compare(this.semiMajorAxisMeters, ellipse.semiMajorAxisMeters) == 0 && Double.compare(this.semiMinorAxisMeters, ellipse.semiMinorAxisMeters) == 0 && Double.compare(this.orientationDegrees, ellipse.orientationDegrees) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.lat, this.lon, this.semiMajorAxisMeters, this.semiMinorAxisMeters, this.orientationDegrees);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ellipse(");
        sb.append("[" + this.lat + "," + this.lon + "]");
        sb.append(" semiMajorAxis = " + this.semiMinorAxisMeters + " meters");
        sb.append(" semiMinorAxis = " + this.semiMinorAxisMeters + " meters");
        sb.append(" orientation = " + this.orientationDegrees + " degrees");
        sb.append(')');
        return sb.toString();
    }
}

