/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import io.skylite.core.geo.CircleUtils;
import io.skylite.geometry.utils.GeospatialUtils;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.Ellipse;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.XYEllipse;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.SloppyMath;

public class Ellipse2D
implements Component2D {
    private final DistanceCalculator calculator;

    private Ellipse2D(DistanceCalculator calculator) {
        this.calculator = calculator;
    }

    public double getMinX() {
        return this.calculator.getMinX();
    }

    public double getMaxX() {
        return this.calculator.getMaxX();
    }

    public double getMinY() {
        return this.calculator.getMinY();
    }

    public double getMaxY() {
        return this.calculator.getMaxY();
    }

    public boolean contains(double x, double y) {
        return this.calculator.contains(x, y);
    }

    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (this.calculator.within(minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return this.calculator.relate(minX, maxX, minY, maxY);
    }

    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) || this.contains(bX, bY) || this.calculator.intersectsLine(aX, aY, bX, bY);
    }

    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY) || Component2D.pointInTriangle((double)minX, (double)maxX, (double)minY, (double)maxY, (double)this.calculator.getX(), (double)this.calculator.getY(), (double)aX, (double)aY, (double)bX, (double)bY, (double)cX, (double)cY) || this.calculator.intersectsLine(aX, aY, bX, bY) || this.calculator.intersectsLine(bX, bY, cX, cY) || this.calculator.intersectsLine(cX, cY, aX, aY);
    }

    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) && this.contains(bX, bY);
    }

    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) && this.contains(bX, bY) && this.contains(cX, cY);
    }

    public Component2D.WithinRelation withinPoint(double x, double y) {
        return this.contains(x, y) ? Component2D.WithinRelation.NOTWITHIN : Component2D.WithinRelation.DISJOINT;
    }

    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (ab && this.calculator.intersectsLine(aX, aY, bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (ab && this.calculator.intersectsLine(aX, aY, bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (bc && this.calculator.intersectsLine(bX, bY, cX, cY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (ca && this.calculator.intersectsLine(cX, cY, aX, aY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (Component2D.pointInTriangle((double)minX, (double)maxX, (double)minY, (double)maxY, (double)this.calculator.getX(), (double)this.calculator.getY(), (double)aX, (double)aY, (double)bX, (double)bY, (double)cX, (double)cY)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    static Component2D create(XYEllipse xyEllipse) {
        CartesianCalculator calculator = new CartesianCalculator(xyEllipse.getX(), xyEllipse.getY(), xyEllipse.getSemiMajorAxisMeters(), xyEllipse.getSemiMinorAxisMeters(), xyEllipse.getOrientationDegrees());
        return new Ellipse2D(calculator);
    }

    static Component2D create(Ellipse circle) {
        HaversinCalculator calculator = new HaversinCalculator(circle.getLat(), circle.getLon(), circle.getSemiMajorAxisMeters(), circle.getSemiMinorAxisMeters(), circle.getOrientationDegrees());
        return new Ellipse2D(calculator);
    }

    public String toString() {
        return "Ellipse2D{calculator=" + String.valueOf(this.calculator) + "}";
    }

    private static interface DistanceCalculator {
        public boolean contains(double var1, double var3);

        public boolean intersectsLine(double var1, double var3, double var5, double var7);

        public PointValues.Relation relate(double var1, double var3, double var5, double var7);

        public boolean disjoint(double var1, double var3, double var5, double var7);

        public boolean within(double var1, double var3, double var5, double var7);

        public double getMinX();

        public double getMaxX();

        public double getMinY();

        public double getMaxY();

        public double getX();

        public double getY();

        public String toString();
    }

    private static class CartesianCalculator
    implements DistanceCalculator {
        final double centerX;
        final double centerY;
        final double semiMajorAxis;
        final double semiMinorAxis;
        final double orientationDegrees;
        final XYRectangle rectangle;

        public CartesianCalculator(double centerX, double centerY, double semiMajorAxis, double semiMinorAxis, double orientationDegrees) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.semiMajorAxis = semiMajorAxis;
            this.semiMinorAxis = semiMinorAxis;
            this.orientationDegrees = orientationDegrees;
            float[] bounds = CircleUtils.calculateCartesianEllipseBounds((double)centerX, (double)centerY, (double)semiMajorAxis, (double)semiMinorAxis, (double)orientationDegrees);
            this.rectangle = new XYRectangle(bounds[1], bounds[3], bounds[0], bounds[2]);
        }

        @Override
        public boolean contains(double x, double y) {
            return CircleUtils.isPointInEllipse((double)x, (double)y, (double)this.centerX, (double)this.centerY, (double)this.semiMajorAxis, (double)this.semiMinorAxis, (double)this.orientationDegrees);
        }

        @Override
        public boolean intersectsLine(double aX, double aY, double bX, double bY) {
            double c;
            double a;
            double semiMinorAxisSquared;
            double rotatedBY;
            double dy;
            double rotatedAY;
            double semiMajorAxisSquared;
            double translatedBY;
            double translatedBX;
            double rotatedBX;
            double dx;
            double sinOrientation;
            double translatedAY;
            if (this.semiMajorAxis <= 0.0 || this.semiMinorAxis <= 0.0) {
                throw new IllegalArgumentException("Semi-major and semi-minor axis lengths must be positive.");
            }
            double translatedAX = aX - this.centerX;
            double orientationRad = Math.toRadians(this.orientationDegrees);
            double cosOrientation = Math.cos(-orientationRad);
            double rotatedAX = translatedAX * cosOrientation - (translatedAY = aY - this.centerY) * (sinOrientation = Math.sin(-orientationRad));
            double b = 2.0 * (rotatedAX * (dx = (rotatedBX = (translatedBX = bX - this.centerX) * cosOrientation - (translatedBY = bY - this.centerY) * sinOrientation) - rotatedAX) / (semiMajorAxisSquared = this.semiMajorAxis * this.semiMajorAxis) + (rotatedAY = translatedAX * sinOrientation + translatedAY * cosOrientation) * (dy = (rotatedBY = translatedBX * sinOrientation + translatedBY * cosOrientation) - rotatedAY) / (semiMinorAxisSquared = this.semiMinorAxis * this.semiMinorAxis));
            double discriminant = b * b - 4.0 * (a = dx * dx / semiMajorAxisSquared + dy * dy / semiMinorAxisSquared) * (c = rotatedAX * rotatedAX / semiMajorAxisSquared + rotatedAY * rotatedAY / semiMinorAxisSquared - 1.0);
            if (discriminant < 0.0) {
                return false;
            }
            double sqrtDiscriminant = Math.sqrt(discriminant);
            double t1 = (-b - sqrtDiscriminant) / (2.0 * a);
            if (t1 >= 0.0 && t1 <= 1.0) {
                return true;
            }
            double t2 = (-b + sqrtDiscriminant) / (2.0 * a);
            return t2 >= 0.0 && t2 <= 1.0;
        }

        @Override
        public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
            if (minX <= this.centerX && this.centerX <= maxX && minY <= this.centerY && this.centerY <= maxY) {
                if (this.contains(minX, minY) && this.contains(maxX, minY) && this.contains(maxX, maxY) && this.contains(minX, maxY)) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            } else {
                double diff;
                double sumOfSquaredDiffs = 0.0;
                if (this.centerX < minX) {
                    diff = minX - this.centerX;
                    sumOfSquaredDiffs += diff * diff;
                } else if (this.centerX > maxX) {
                    diff = this.centerX - maxX;
                    sumOfSquaredDiffs += diff * diff;
                }
                if (this.centerY < minY) {
                    diff = minY - this.centerY;
                    sumOfSquaredDiffs += diff * diff;
                } else if (this.centerY > maxY) {
                    diff = this.centerY - maxY;
                    sumOfSquaredDiffs += diff * diff;
                }
                if (sumOfSquaredDiffs > this.semiMajorAxis * this.semiMajorAxis) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        @Override
        public boolean disjoint(double minX, double maxX, double minY, double maxY) {
            return Component2D.disjoint((double)this.rectangle.minX, (double)this.rectangle.maxX, (double)this.rectangle.minY, (double)this.rectangle.maxY, (double)minX, (double)maxX, (double)minY, (double)maxY);
        }

        @Override
        public boolean within(double minX, double maxX, double minY, double maxY) {
            return Component2D.within((double)this.rectangle.minX, (double)this.rectangle.maxX, (double)this.rectangle.minY, (double)this.rectangle.maxY, (double)minX, (double)maxX, (double)minY, (double)maxY);
        }

        @Override
        public double getMinX() {
            return this.rectangle.minY;
        }

        @Override
        public double getMaxX() {
            return this.rectangle.maxX;
        }

        @Override
        public double getMinY() {
            return this.rectangle.minY;
        }

        @Override
        public double getMaxY() {
            return this.rectangle.maxY;
        }

        @Override
        public double getX() {
            return this.centerX;
        }

        @Override
        public double getY() {
            return this.centerY;
        }

        @Override
        public String toString() {
            return "CartesianCalculator{centerX=" + this.centerX + ", centerY=" + this.centerY + ", semiMajorAxis=" + this.semiMajorAxis + ", semiMinorAxis=" + this.semiMinorAxis + ", orientationDegrees=" + this.orientationDegrees + ", rectangle=" + String.valueOf(this.rectangle) + "}";
        }
    }

    private static class HaversinCalculator
    implements DistanceCalculator {
        final double centerLat;
        final double centerLon;
        final double semiMajorAxisMeters;
        final double semiMinorAxisMeters;
        final double orientationDegrees;
        final boolean crossesDateline;
        final double sortKey;
        final Rectangle rectangle;

        public HaversinCalculator(double centerLat, double centerLon, double semiMajorAxisMeters, double semiMinorAxisMeters, double orientationDegrees) {
            this.centerLat = centerLat;
            this.centerLon = centerLon;
            this.semiMajorAxisMeters = semiMajorAxisMeters;
            this.semiMinorAxisMeters = semiMinorAxisMeters;
            this.orientationDegrees = orientationDegrees;
            this.sortKey = GeoUtils.distanceQuerySortKey((double)semiMajorAxisMeters);
            double[] bounds = HaversinCalculator.calculateGeographicEllipseBounds(centerLat, centerLon, semiMajorAxisMeters, semiMinorAxisMeters, orientationDegrees);
            this.rectangle = new Rectangle(bounds[0], bounds[2], bounds[1], bounds[3]);
            this.crossesDateline = this.rectangle.minLon > this.rectangle.maxLon;
        }

        @Override
        public boolean intersectsLine(double aX, double aY, double bX, double bY) {
            if (HaversinCalculator.intersectsLine(this.centerLat, this.centerLon, aY, aX, bY, bX, this)) {
                return true;
            }
            if (this.crossesDateline) {
                double newCenterLon = this.centerLon > 0.0 ? this.centerLon - 360.0 : this.centerLon + 360.0;
                return HaversinCalculator.intersectsLine(this.centerLat, newCenterLon, aY, aX, bY, bX, this);
            }
            return false;
        }

        @Override
        public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
            if (this.semiMajorAxisMeters <= 0.0 || this.semiMinorAxisMeters <= 0.0) {
                throw new IllegalArgumentException("Semi-major and semi-minor axes must be positive.");
            }
            double orientationRad = Math.toRadians(this.orientationDegrees);
            double cosOrientation = Math.cos(orientationRad);
            double sinOrientation = Math.sin(orientationRad);
            double[][] corners = new double[][]{{this.rectangle.minLat, this.rectangle.minLon}, {this.rectangle.minLat, this.rectangle.maxLon}, {this.rectangle.maxLat, this.rectangle.minLon}, {this.rectangle.maxLat, this.rectangle.maxLon}};
            boolean anyInside = false;
            boolean allInside = true;
            boolean allOutside = true;
            boolean edgeIntersects = false;
            for (double[] corner : corners) {
                double lat = corner[0];
                double lon = corner[1];
                boolean isInside = this.isPointInsideEllipse(lat, lon, orientationRad);
                if (isInside) {
                    anyInside = true;
                    allOutside = false;
                    continue;
                }
                allInside = false;
            }
            edgeIntersects |= HaversinCalculator.intersectsLine(this.centerLat, this.centerLon, minY, minX, minY, maxX, this);
            edgeIntersects |= HaversinCalculator.intersectsLine(this.centerLat, this.centerLon, minY, maxX, maxY, maxX, this);
            edgeIntersects |= HaversinCalculator.intersectsLine(this.centerLat, this.centerLon, maxY, maxX, maxY, minX, this);
            if (allOutside && !(edgeIntersects |= HaversinCalculator.intersectsLine(this.centerLat, this.centerLon, maxY, minX, minY, minX, this))) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (allInside && !edgeIntersects) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        @Override
        public boolean contains(double lon, double lat) {
            if (this.crossesDateline ? Component2D.containsPoint((double)lon, (double)lat, (double)this.rectangle.minLon, (double)180.0, (double)this.rectangle.minLat, (double)this.rectangle.maxLat) || Component2D.containsPoint((double)lon, (double)lat, (double)-180.0, (double)this.rectangle.maxLon, (double)this.rectangle.minLat, (double)this.rectangle.maxLat) : Component2D.containsPoint((double)lon, (double)lat, (double)this.rectangle.minLon, (double)this.rectangle.maxLon, (double)this.rectangle.minLat, (double)this.rectangle.maxLat)) {
                return SloppyMath.haversinSortKey((double)lat, (double)lon, (double)this.centerLat, (double)this.centerLon) <= this.sortKey && this.isPointInsideEllipse(lat, lon, Math.toRadians(this.orientationDegrees));
            }
            return false;
        }

        private static boolean intersectsLine(double centerLat, double centerLon, double aLat, double aLon, double bLat, double bLon, HaversinCalculator calculator) {
            double orientationRadians = Math.toRadians(calculator.orientationDegrees);
            if (calculator.isPointInsideEllipse(aLat, aLon, orientationRadians) || calculator.isPointInsideEllipse(bLat, bLon, orientationRadians)) {
                return true;
            }
            double initialBearing = GeospatialUtils.initialBearing((double)aLat, (double)aLon, (double)bLat, (double)bLon);
            double greatCircleDistanceAB = SloppyMath.haversinMeters((double)aLat, (double)aLon, (double)bLat, (double)bLon);
            double crossTrackDistance = GeospatialUtils.crossTrackDistance((double)centerLat, (double)centerLon, (double)aLat, (double)aLon, (double)bLat, (double)bLon);
            if (crossTrackDistance <= 1.0E-6) {
                return true;
            }
            if (crossTrackDistance > calculator.semiMajorAxisMeters) {
                return false;
            }
            double alongTrackDistance = GeospatialUtils.alongTrackDistance((double)aLat, (double)aLon, (double)centerLat, (double)centerLon, (double)bLat, (double)bLon);
            alongTrackDistance = Math.max(0.0, Math.min(alongTrackDistance, greatCircleDistanceAB));
            double[] closestPointP = GeospatialUtils.pointAlongGreatCircle((double)aLat, (double)aLon, (double)alongTrackDistance, (double)Math.toRadians(initialBearing));
            double pLat = closestPointP[0];
            double pLon = closestPointP[1];
            pLon = GeospatialUtils.normalizeLongitude((double)pLon);
            return calculator.isPointInsideEllipse(pLat, pLon, orientationRadians);
        }

        private boolean isPointInsideEllipse(double pointLat, double pointLon, double orientationRadians) {
            double minorAxisTerm;
            double distanceMeters = SloppyMath.haversinMeters((double)this.centerLat, (double)this.centerLon, (double)pointLat, (double)pointLon);
            if (distanceMeters > this.semiMajorAxisMeters) {
                return false;
            }
            double relativeBearing = Math.atan2(Math.toRadians(pointLat - this.centerLat), Math.toRadians(pointLon - this.centerLon));
            double rotatedX = distanceMeters * Math.cos(relativeBearing - orientationRadians);
            double rotatedY = distanceMeters * Math.sin(relativeBearing - orientationRadians);
            double majorAxisTerm = Math.pow(rotatedX / this.semiMajorAxisMeters, 2.0);
            return majorAxisTerm + (minorAxisTerm = Math.pow(rotatedY / this.semiMinorAxisMeters, 2.0)) <= 1.0;
        }

        private VincentyResult vincentyInverse(double lat1, double lon1, double lat2, double lon2) {
            double cosLambda;
            double sinLambda;
            double lambdaP;
            double cosSigma;
            double cos2SigmaM;
            double sinSigma;
            double sigma;
            double sinAlpha;
            double cos2Alpha;
            double C;
            double a = 6378137.0;
            double f = 0.0033528106647474805;
            double b = 6356752.314245179;
            double U1 = Math.atan(0.9966471893352525 * Math.tan(Math.toRadians(lat1)));
            double U2 = Math.atan(0.9966471893352525 * Math.tan(Math.toRadians(lat2)));
            double L = Math.toRadians(lon2 - lon1);
            double sinU1 = Math.sin(U1);
            double cosU1 = Math.cos(U1);
            double sinU2 = Math.sin(U2);
            double cosU2 = Math.cos(U2);
            double lambda = L;
            double iterLimit = 100.0;
            double s = 0.0;
            double alpha1 = 0.0;
            do {
                if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda))) == 0.0) {
                    return new VincentyResult(0.0, 0.0);
                }
                cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda;
                sigma = Math.atan2(sinSigma, cosSigma);
                sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma;
                cos2Alpha = 1.0 - sinAlpha * sinAlpha;
                cos2SigmaM = cosSigma - 2.0 * sinU1 * sinU2 / cos2Alpha;
                if (!Double.isNaN(cos2SigmaM)) continue;
                cos2SigmaM = 0.0;
            } while (Math.abs((lambda = L + (1.0 - (C = 2.0955066654671753E-4 * cos2Alpha * (4.0 + 0.0033528106647474805 * (4.0 - 3.0 * cos2Alpha)))) * 0.0033528106647474805 * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && (iterLimit -= 1.0) > 0.0);
            if (iterLimit == 0.0) {
                return new VincentyResult(Double.NaN, Double.NaN);
            }
            double uSq = cos2Alpha * 2.723316061075547E11 / 4.0408299984661445E13;
            double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
            double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
            double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
            s = 6356752.314245179 * A * (sigma - deltaSigma);
            alpha1 = Math.toDegrees(Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda));
            return new VincentyResult(s, alpha1);
        }

        @Override
        public boolean disjoint(double minX, double maxX, double minY, double maxY) {
            if (this.crossesDateline) {
                return Component2D.disjoint((double)this.rectangle.minLon, (double)180.0, (double)this.rectangle.minLat, (double)this.rectangle.maxLat, (double)minX, (double)maxX, (double)minY, (double)maxY) && Component2D.disjoint((double)-180.0, (double)this.rectangle.maxLon, (double)this.rectangle.minLat, (double)this.rectangle.maxLat, (double)minX, (double)maxX, (double)minY, (double)maxY);
            }
            return Component2D.disjoint((double)this.rectangle.minLon, (double)this.rectangle.maxLon, (double)this.rectangle.minLat, (double)this.rectangle.maxLat, (double)minX, (double)maxX, (double)minY, (double)maxY);
        }

        @Override
        public boolean within(double minX, double maxX, double minY, double maxY) {
            if (this.crossesDateline) {
                return Component2D.within((double)this.rectangle.minLon, (double)180.0, (double)this.rectangle.minLat, (double)this.rectangle.maxLat, (double)minX, (double)maxX, (double)minY, (double)maxY) || Component2D.within((double)-180.0, (double)this.rectangle.maxLon, (double)this.rectangle.minLat, (double)this.rectangle.maxLat, (double)minX, (double)maxX, (double)minY, (double)maxY);
            }
            return Component2D.within((double)this.rectangle.minLon, (double)this.rectangle.maxLon, (double)this.rectangle.minLat, (double)this.rectangle.maxLat, (double)minX, (double)maxX, (double)minY, (double)maxY);
        }

        @Override
        public double getMinX() {
            if (this.crossesDateline) {
                return -180.0;
            }
            return this.rectangle.minLon;
        }

        @Override
        public double getMaxX() {
            if (this.crossesDateline) {
                return 180.0;
            }
            return this.rectangle.maxLon;
        }

        @Override
        public double getMinY() {
            return this.rectangle.minLat;
        }

        @Override
        public double getMaxY() {
            return this.rectangle.maxLat;
        }

        @Override
        public double getX() {
            return this.centerLon;
        }

        @Override
        public double getY() {
            return this.centerLat;
        }

        public static double[] calculateGeographicEllipseBounds(double centerLat, double centerLon, double semiMajorAxis, double semiMinorAxis, double orientationDegrees) {
            double maxLon;
            double minLon;
            if (semiMajorAxis <= 0.0 || semiMinorAxis <= 0.0) {
                throw new IllegalArgumentException("SemiMajorAxis and SemiMinorAxis lengths must be positive.");
            }
            if (orientationDegrees < 0.0 || orientationDegrees >= 360.0) {
                throw new IllegalArgumentException("Orientation must be between 0 and 360 degrees.");
            }
            double orientationRad = Math.toRadians(orientationDegrees);
            double latCos = Math.cos(Math.toRadians(centerLat));
            double latOffsetMajor = semiMajorAxis / 6371008.7714 * 57.29577951308232;
            double lonOffsetMajor = semiMajorAxis / (6371008.7714 * latCos) * 57.29577951308232;
            double latOffsetMinor = semiMinorAxis / 6371008.7714 * 57.29577951308232;
            double lonOffsetMinor = semiMinorAxis / (6371008.7714 * latCos) * 57.29577951308232;
            double minLat = centerLat - latOffsetMajor * Math.abs(Math.sin(orientationRad)) - latOffsetMinor * Math.abs(Math.cos(orientationRad));
            double maxLat = centerLat + latOffsetMajor * Math.abs(Math.sin(orientationRad)) + latOffsetMinor * Math.abs(Math.cos(orientationRad));
            if (Math.abs(centerLat) >= 89.5) {
                minLon = -180.0;
                maxLon = 180.0;
            } else {
                minLon = centerLon - lonOffsetMajor * Math.abs(Math.cos(orientationRad)) - lonOffsetMinor * Math.abs(Math.sin(orientationRad));
                maxLon = centerLon + lonOffsetMajor * Math.abs(Math.cos(orientationRad)) + lonOffsetMinor * Math.abs(Math.sin(orientationRad));
                if ((maxLon %= 360.0) > 180.0) {
                    maxLon -= 360.0;
                }
                if ((minLon %= 360.0) < -180.0) {
                    minLon += 360.0;
                }
            }
            minLat = Math.max(minLat, -90.0);
            maxLat = Math.min(maxLat, 90.0);
            return new double[]{minLat, minLon, maxLat, maxLon};
        }

        @Override
        public String toString() {
            return "HaversinCalculator{centerLat=" + this.centerLat + ", centerLon=" + this.centerLon + ", semiMajorAxisMeters=" + this.semiMajorAxisMeters + ", semiMinorAxisMeters=" + this.semiMinorAxisMeters + ", orientationDegrees=" + this.orientationDegrees + ", crossesDateline=" + this.crossesDateline + ", sortKey=" + this.sortKey + ", rectangle=" + String.valueOf(this.rectangle) + "}";
        }

        private static class VincentyResult {
            double distance;
            double initialBearing;

            VincentyResult(double distance, double initialBearing) {
                this.distance = distance;
                this.initialBearing = initialBearing;
            }
        }
    }
}

