/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Objects;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.Ellipse2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYGeometry;

public final class XYEllipse
extends XYGeometry {
    private final float x;
    private final float y;
    private final float semiMajorAxisMeters;
    private final float semiMinorAxisMeters;
    private final float orientationDegrees;

    public XYEllipse(float x, float y, float semiMajorAxisMeters, float semiMinorAxisMeters, float orientationDegrees) {
        if (semiMajorAxisMeters <= 0.0f) {
            throw new IllegalArgumentException("semiMajorAxis must be bigger than 0, got " + semiMajorAxisMeters);
        }
        if (!Float.isFinite(semiMajorAxisMeters)) {
            throw new IllegalArgumentException("semiMajorAxis must be finite, got " + semiMajorAxisMeters);
        }
        if (semiMinorAxisMeters <= 0.0f) {
            throw new IllegalArgumentException("semiMinorAxis must be bigger than 0, got " + semiMinorAxisMeters);
        }
        if (!Float.isFinite(semiMinorAxisMeters)) {
            throw new IllegalArgumentException("semiMinorAxis must be finite, got " + semiMinorAxisMeters);
        }
        if (orientationDegrees < 0.0f) {
            throw new IllegalArgumentException("orientation must be bigger than 0, got " + orientationDegrees);
        }
        if (!Float.isFinite(orientationDegrees)) {
            throw new IllegalArgumentException("orientation must be finite, got " + orientationDegrees);
        }
        this.x = XYEncodingUtils.checkVal((float)x);
        this.y = XYEncodingUtils.checkVal((float)y);
        this.semiMajorAxisMeters = semiMajorAxisMeters;
        this.semiMinorAxisMeters = semiMinorAxisMeters;
        this.orientationDegrees = orientationDegrees;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getSemiMajorAxisMeters() {
        return this.semiMajorAxisMeters;
    }

    public float getSemiMinorAxisMeters() {
        return this.semiMinorAxisMeters;
    }

    public float getOrientationDegrees() {
        return this.orientationDegrees;
    }

    protected Component2D toComponent2D() {
        return Ellipse2D.create(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        XYEllipse xyEllipse = (XYEllipse)((Object)o);
        return Float.compare(this.x, xyEllipse.x) == 0 && Float.compare(this.y, xyEllipse.y) == 0 && Float.compare(this.semiMajorAxisMeters, xyEllipse.semiMajorAxisMeters) == 0 && Float.compare(this.semiMinorAxisMeters, xyEllipse.semiMinorAxisMeters) == 0 && Float.compare(this.orientationDegrees, xyEllipse.orientationDegrees) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.semiMajorAxisMeters), Float.valueOf(this.semiMinorAxisMeters), Float.valueOf(this.orientationDegrees));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ELLIPSE(");
        sb.append("[" + this.x + "," + this.y + "]");
        sb.append(" semiMajorAxisMeters = " + this.semiMajorAxisMeters);
        sb.append(" semiMinorAxisMeters = " + this.semiMinorAxisMeters);
        sb.append(" orientationDegrees = " + this.orientationDegrees);
        sb.append(')');
        return sb.toString();
    }
}

