/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentTooLongException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityConsumer;
import org.apache.hc.core5.util.ByteArrayBuffer;

public class HeapBufferedAsyncEntityConsumer
extends AbstractBinAsyncEntityConsumer<byte[]> {
    private final int bufferLimitBytes;
    private AtomicReference<ByteArrayBuffer> bufferRef = new AtomicReference();

    public HeapBufferedAsyncEntityConsumer(int bufferLimit) {
        if (bufferLimit <= 0) {
            throw new IllegalArgumentException("bufferLimit must be greater than 0");
        }
        this.bufferLimitBytes = bufferLimit;
    }

    public int getBufferLimit() {
        return this.bufferLimitBytes;
    }

    protected void streamStart(ContentType contentType) throws HttpException, IOException {
    }

    protected int capacityIncrement() {
        return Integer.MAX_VALUE;
    }

    protected void data(ByteBuffer src, boolean endOfStream) throws IOException {
        if (src == null) {
            return;
        }
        int len = src.limit();
        if (len < 0) {
            len = 4096;
        } else if (len > this.bufferLimitBytes) {
            throw new ContentTooLongException("entity content is too long [" + len + "] for the configured buffer limit [" + this.bufferLimitBytes + "]");
        }
        ByteArrayBuffer buffer = this.bufferRef.get();
        if (buffer == null && !this.bufferRef.compareAndSet(null, buffer = new ByteArrayBuffer(len))) {
            buffer = this.bufferRef.get();
        }
        if (buffer.length() + len > this.bufferLimitBytes) {
            throw new ContentTooLongException("entity content is too long [" + len + "] for the configured buffer limit [" + this.bufferLimitBytes + "]");
        }
        if (src.hasArray()) {
            buffer.append(src.array(), src.arrayOffset() + src.position(), src.remaining());
        } else {
            while (src.hasRemaining()) {
                buffer.append((int)src.get());
            }
        }
    }

    protected byte[] generateContent() throws IOException {
        ByteArrayBuffer buffer = this.bufferRef.get();
        return buffer == null ? new byte[]{} : buffer.toByteArray();
    }

    public void releaseResources() {
        ByteArrayBuffer buffer = this.bufferRef.getAndSet(null);
        if (buffer != null) {
            buffer.clear();
            buffer = null;
        }
    }

    ByteArrayBuffer getBuffer() {
        return this.bufferRef.get();
    }
}

