/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.jobscheduler.rest.action;

import io.lucenia.jobscheduler.rest.request.GetJobDetailsRequest;
import io.lucenia.jobscheduler.utils.JobDetailsService;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;

public class RestGetJobDetailsAction
extends BaseRestHandler {
    public static final String GET_JOB_DETAILS_ACTION = "get_job_details_action";
    private final Logger logger = LogManager.getLogger(RestGetJobDetailsAction.class);
    public JobDetailsService jobDetailsService;

    public RestGetJobDetailsAction(JobDetailsService jobDetailsService) {
        this.jobDetailsService = jobDetailsService;
    }

    public String getName() {
        return GET_JOB_DETAILS_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/%s", "/_plugins/_job_scheduler", "_job_details")), new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_job_scheduler", "_job_details", "document_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        XContentParser parser = restRequest.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        GetJobDetailsRequest getJobDetailsRequest = GetJobDetailsRequest.parse(parser);
        String documentId = restRequest.param("document_id");
        String jobIndex = getJobDetailsRequest.getJobIndex();
        String jobType = getJobDetailsRequest.getJobType();
        String jobParameterAction = getJobDetailsRequest.getJobParameterAction();
        String jobRunnerAction = getJobDetailsRequest.getJobRunnerAction();
        String extensionUniqueId = getJobDetailsRequest.getExtensionUniqueId();
        CompletableFuture inProgressFuture = new CompletableFuture();
        this.jobDetailsService.processJobDetails(documentId, jobIndex, jobType, jobParameterAction, jobRunnerAction, extensionUniqueId, (ActionListener<String>)ActionListenerHelper.wrap(indexedDocumentId -> inProgressFuture.complete(indexedDocumentId), e -> {
            this.logger.info("could not process job index", (Throwable)e);
            inProgressFuture.completeExceptionally((Throwable)e);
        }));
        try {
            inProgressFuture.orTimeout(JobDetailsService.TIME_OUT_FOR_REQUEST, TimeUnit.SECONDS);
        }
        catch (CompletionException e2) {
            if (e2.getCause() instanceof TimeoutException) {
                this.logger.error("Get Job Details timed out ", (Throwable)e2);
            }
            if (e2.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e2.getCause();
            }
            if (e2.getCause() instanceof Error) {
                throw (Error)e2.getCause();
            }
            throw new RuntimeException(e2.getCause());
        }
        return channel -> {
            BytesRestResponse bytesRestResponse;
            String jobDetailsResponseHolder = null;
            try {
                jobDetailsResponseHolder = (String)inProgressFuture.get();
            }
            catch (Exception e) {
                this.logger.error("Exception occured in get job details ", (Throwable)e);
            }
            XContentBuilder builder = channel.newBuilder();
            RestStatus restStatus = RestStatus.OK;
            String restResponseString = jobDetailsResponseHolder != null ? "success" : "failed";
            try {
                builder.startObject();
                builder.field("response", restResponseString);
                if (restResponseString.equals("success")) {
                    builder.field("document_id", jobDetailsResponseHolder);
                } else {
                    restStatus = RestStatus.INTERNAL_SERVER_ERROR;
                }
                builder.endObject();
                bytesRestResponse = new BytesRestResponse(restStatus, builder);
            }
            finally {
                builder.close();
            }
            channel.sendResponse((RestResponse)bytesRestResponse);
        };
    }
}

