/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.jobscheduler.scheduler;

import io.lucenia.jobscheduler.scheduler.JobSchedulingInfo;
import io.lucenia.jobscheduler.scheduler.ScheduledJobInfo;
import io.skylite.common.Randomness;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.jobs.JobDocVersion;
import io.skylite.core.jobs.JobExecutionContext;
import io.skylite.core.jobs.LockService;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.jobs.ScheduledJobRunner;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobScheduler {
    private static final Logger log = LogManager.getLogger(JobScheduler.class);
    private ThreadPool threadPool;
    private ScheduledJobInfo scheduledJobInfo;
    private Clock clock;
    private final LockService lockService;

    public JobScheduler(ThreadPool threadPool, LockService lockService) {
        this.threadPool = threadPool;
        this.scheduledJobInfo = new ScheduledJobInfo();
        this.clock = Clock.systemDefaultZone();
        this.lockService = lockService;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    ScheduledJobInfo getScheduledJobInfo() {
        return this.scheduledJobInfo;
    }

    public Set<String> getScheduledJobIds(String indexName) {
        return this.scheduledJobInfo.getJobsByIndex(indexName).keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schedule(String indexName, String docId, ScheduledJobParameter scheduledJobParameter, ScheduledJobRunner jobRunner, JobDocVersion version, Double jitterLimit) {
        if (!scheduledJobParameter.isEnabled()) {
            return false;
        }
        log.info("Scheduling job id {} for index {} .", (Object)docId, (Object)indexName);
        Map<String, JobSchedulingInfo> map = this.scheduledJobInfo.getJobsByIndex(indexName);
        synchronized (map) {
            JobSchedulingInfo jobInfo = this.scheduledJobInfo.getJobInfo(indexName, docId);
            if (jobInfo == null) {
                jobInfo = new JobSchedulingInfo(indexName, docId, scheduledJobParameter);
                this.scheduledJobInfo.addJob(indexName, docId, jobInfo);
            }
            if (jobInfo.getScheduledCancellable() != null) {
                return true;
            }
            this.reschedule(scheduledJobParameter, jobInfo, jobRunner, version, jitterLimit);
        }
        return true;
    }

    public List<String> bulkDeschedule(String indexName, Collection<String> ids) {
        if (ids == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String id : ids) {
            if (this.deschedule(indexName, id)) continue;
            result.add(id);
            log.error("Unable to deschedule job {}", (Object)id);
        }
        return result;
    }

    public boolean deschedule(String indexName, String id) {
        JobSchedulingInfo jobInfo = this.scheduledJobInfo.getJobInfo(indexName, id);
        if (jobInfo == null) {
            log.debug("JobId {} doesn't not exist, skip descheduling.", (Object)id);
            return true;
        }
        log.info("Descheduling jobId: {}", (Object)id);
        jobInfo.setDescheduled(true);
        jobInfo.setActualPreviousExecutionTime(null);
        jobInfo.setExpectedPreviousExecutionTime(null);
        Scheduler.ScheduledCancellable scheduledCancellable = jobInfo.getScheduledCancellable();
        if (scheduledCancellable != null && !scheduledCancellable.cancel()) {
            return false;
        }
        this.scheduledJobInfo.removeJob(indexName, id);
        return true;
    }

    boolean reschedule(ScheduledJobParameter jobParameter, JobSchedulingInfo jobInfo, ScheduledJobRunner jobRunner, JobDocVersion version, Double jitterLimit) {
        Duration interval;
        Instant secondExecutionTimeFromNow;
        if (jobParameter.getEnabledTime() == null) {
            log.info("There is no enable time of job {}, this job should never be scheduled.", (Object)jobParameter.getName());
            return false;
        }
        Instant nextExecutionTime = jobParameter.getSchedule().getNextExecutionTime(jobInfo.getExpectedExecutionTime());
        if (nextExecutionTime == null) {
            log.info("No next execution time for job {}", (Object)jobParameter.getName());
            return true;
        }
        Instant now = this.clock.instant();
        Duration duration = Duration.between(now, nextExecutionTime);
        if (duration.isNegative()) {
            log.info("job {} expected time: {} < current time: {}, setting next execute time to current", (Object)jobParameter.getName(), (Object)nextExecutionTime.toEpochMilli(), (Object)now.toEpochMilli());
            nextExecutionTime = now;
            duration = Duration.ZERO;
        }
        if ((secondExecutionTimeFromNow = jobParameter.getSchedule().getNextExecutionTime(nextExecutionTime)) != null && (interval = Duration.between(nextExecutionTime, secondExecutionTimeFromNow)).toMillis() > 0L) {
            double jitter = jobParameter.getJitter() == null ? 0.0 : jobParameter.getJitter();
            jitter = jitter > jitterLimit ? jitterLimit : jitter;
            jitter = jitter < 0.0 ? 0.0 : jitter;
            long randomLong = Randomness.get().nextLong();
            if (randomLong == Long.MIN_VALUE) {
                randomLong += 17L;
            }
            long randomPositiveLong = randomLong < 0L ? randomLong * -1L : randomLong;
            long jitterMillis = Math.round((double)(randomPositiveLong % interval.toMillis()) * jitter);
            if (jitter > 0.0) {
                log.info("Will delay {} miliseconds for next execution of job {}", (Object)jitterMillis, (Object)jobParameter.getName());
            }
            duration = duration.plusMillis(jitterMillis);
        }
        jobInfo.setExpectedExecutionTime(nextExecutionTime);
        Runnable runnable = () -> {
            if (jobInfo.isDescheduled()) {
                return;
            }
            jobInfo.setExpectedPreviousExecutionTime(jobInfo.getExpectedExecutionTime());
            jobInfo.setActualPreviousExecutionTime(this.clock.instant());
            this.reschedule(jobParameter, jobInfo, jobRunner, version, jitterLimit);
            JobExecutionContext context = new JobExecutionContext(jobInfo.getExpectedPreviousExecutionTime(), version, this.lockService, jobInfo.getIndexName(), jobInfo.getJobId());
            jobRunner.runJob(jobParameter, context);
        };
        if (jobInfo.isDescheduled()) {
            return false;
        }
        jobInfo.setScheduledCancellable(this.threadPool.schedule(runnable, new TimeValue(duration.toNanos(), TimeUnit.NANOSECONDS), "open_distro_job_scheduler"));
        return true;
    }
}

