/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.jobscheduler.sweeper;

import io.lucenia.jobscheduler.JobSchedulerSettings;
import io.lucenia.jobscheduler.ScheduledJobProvider;
import io.lucenia.jobscheduler.scheduler.JobScheduler;
import io.lucenia.jobscheduler.utils.JobDetailsService;
import io.skylite.SkyliteException;
import io.skylite.common.lifecycle.LifecycleListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.set.Sets;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.routing.IndexShardRoutingTable;
import io.skylite.core.cluster.routing.Murmur3HashFunction;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.shard.IndexingOperationListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.jobs.JobDocVersion;
import io.skylite.core.jobs.LockModel;
import io.skylite.core.jobs.LockService;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.search.sort.FieldSortBuilder;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.jobs.ScheduledJobRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class JobSweeper
extends LifecycleListener
implements IndexingOperationListener,
ClusterStateListener {
    private static final Logger log = LogManager.getLogger(JobSweeper.class);
    private Client client;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private Map<String, ScheduledJobProvider> indexToProviders;
    private NamedXContentRegistry xContentRegistry;
    private Scheduler.Cancellable scheduledFullSweep;
    private ExecutorService fullSweepExecutor;
    private ConcurrentHashMap<ShardId, ConcurrentHashMap<String, JobDocVersion>> sweptJobs;
    private JobScheduler scheduler;
    private LockService lockService;
    private JobDetailsService jobDetailsService;
    private volatile long lastFullSweepTimeNano;
    private volatile TimeValue sweepPeriod;
    private volatile Integer sweepPageMaxSize;
    private volatile TimeValue sweepSearchTimeout;
    private volatile TimeValue sweepSearchBackoffMillis;
    private volatile Integer sweepSearchBackoffRetryCount;
    private volatile BackoffPolicy sweepSearchBackoff;
    private volatile Double jitterLimit;

    public JobSweeper(Settings settings, Client client, ClusterService clusterService, ThreadPool threadPool, NamedXContentRegistry registry, Map<String, ScheduledJobProvider> indexToProviders, JobScheduler scheduler, LockService lockService, JobDetailsService jobDetailsService) {
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.xContentRegistry = registry;
        this.indexToProviders = indexToProviders;
        this.scheduler = scheduler;
        this.lockService = lockService;
        this.jobDetailsService = jobDetailsService;
        this.lastFullSweepTimeNano = System.nanoTime();
        this.loadSettings(settings);
        this.addConfigListeners();
        this.fullSweepExecutor = Executors.newSingleThreadExecutor(SkyliteExecutors.daemonThreadFactory((String)"opendistro_job_sweeper"));
        this.sweptJobs = new ConcurrentHashMap();
    }

    private void loadSettings(Settings settings) {
        this.sweepPeriod = (TimeValue)JobSchedulerSettings.SWEEP_PERIOD.get(settings);
        this.sweepPageMaxSize = (Integer)JobSchedulerSettings.SWEEP_PAGE_SIZE.get(settings);
        this.sweepSearchTimeout = (TimeValue)JobSchedulerSettings.REQUEST_TIMEOUT.get(settings);
        this.sweepSearchBackoffMillis = (TimeValue)JobSchedulerSettings.SWEEP_BACKOFF_MILLIS.get(settings);
        this.sweepSearchBackoffRetryCount = (Integer)JobSchedulerSettings.SWEEP_BACKOFF_RETRY_COUNT.get(settings);
        this.jitterLimit = (Double)JobSchedulerSettings.JITTER_LIMIT.get(settings);
        this.sweepSearchBackoff = this.updateRetryPolicy();
    }

    private void addConfigListeners() {
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(JobSchedulerSettings.SWEEP_PERIOD, timeValue -> {
            this.sweepPeriod = timeValue;
            log.debug("Reinitializing background full sweep with period: {}", (Object)this.sweepPeriod.getMinutes());
            this.initBackgroundSweep();
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(JobSchedulerSettings.SWEEP_PAGE_SIZE, intValue -> {
            this.sweepPageMaxSize = intValue;
            log.debug("Setting background sweep page size: {}", (Object)this.sweepPageMaxSize);
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(JobSchedulerSettings.REQUEST_TIMEOUT, timeValue -> {
            this.sweepSearchTimeout = timeValue;
            log.debug("Setting background sweep search timeout: {}", (Object)this.sweepSearchTimeout.getMinutes());
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(JobSchedulerSettings.SWEEP_BACKOFF_MILLIS, timeValue -> {
            this.sweepSearchBackoffMillis = timeValue;
            this.sweepSearchBackoff = this.updateRetryPolicy();
            log.debug("Setting background sweep search backoff: {}", (Object)this.sweepSearchBackoffMillis.getMillis());
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(JobSchedulerSettings.SWEEP_BACKOFF_RETRY_COUNT, intValue -> {
            this.sweepSearchBackoffRetryCount = intValue;
            this.sweepSearchBackoff = this.updateRetryPolicy();
            log.debug("Setting background sweep search backoff retry count: {}", (Object)this.sweepSearchBackoffRetryCount);
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(JobSchedulerSettings.JITTER_LIMIT, doubleValue -> {
            this.jitterLimit = doubleValue;
            log.debug("Setting background sweep jitter limit: {}", (Object)this.jitterLimit);
        });
    }

    private BackoffPolicy updateRetryPolicy() {
        return BackoffPolicy.exponentialBackoff((TimeValue)this.sweepSearchBackoffMillis, (int)this.sweepSearchBackoffRetryCount);
    }

    public void afterStart() {
        this.initBackgroundSweep();
    }

    public void beforeStop() {
        if (this.scheduledFullSweep != null) {
            this.scheduledFullSweep.cancel();
        }
    }

    public void beforeClose() {
        this.fullSweepExecutor.shutdown();
    }

    public void postIndex(ShardId shardId, EngineOperation.Index index, EngineResult.IndexResult result) {
        if (result.getResultType().equals((Object)EngineResult.Type.FAILURE)) {
            log.info("Indexing failed for job {} on index {}", (Object)index.id(), (Object)shardId.getIndexName());
            return;
        }
        String localNodeId = this.clusterService.localNode().getId();
        IndexShardRoutingTable routingTable = this.clusterService.state().routingTable().shardRoutingTable(shardId);
        ArrayList<String> shardNodeIds = new ArrayList<String>();
        for (ShardRouting shardRouting : routingTable) {
            if (!shardRouting.active()) continue;
            shardNodeIds.add(shardRouting.currentNodeId());
        }
        ShardNodes shardNodes = new ShardNodes(localNodeId, shardNodeIds);
        if (shardNodes.isOwningNode(index.id())) {
            this.sweep(shardId, index.id(), index.source(), new JobDocVersion(result.getTerm(), result.getSeqNo(), result.getVersion()));
        }
    }

    public void postDelete(ShardId shardId, EngineOperation.Delete delete, EngineResult.DeleteResult result) {
        if (result.getResultType() == EngineResult.Type.FAILURE) {
            ConcurrentHashMap shardJobs = this.sweptJobs.containsKey(shardId) ? this.sweptJobs.get(shardId) : new ConcurrentHashMap();
            JobDocVersion version = (JobDocVersion)shardJobs.get(delete.id());
            log.debug("Deletion failed for scheduled job {}. Continuing with current version {}", (Object)delete.id(), (Object)version);
            return;
        }
        if (this.scheduler.getScheduledJobIds(shardId.getIndexName()).contains(delete.id())) {
            log.info("Descheduling job {} on index {}", (Object)delete.id(), (Object)shardId.getIndexName());
            this.scheduler.deschedule(shardId.getIndexName(), delete.id());
            this.lockService.deleteLock(LockModel.generateLockId((String)shardId.getIndexName(), (String)delete.id()), ActionListenerHelper.wrap(deleted -> log.debug("Deleted lock: {}", deleted), exception -> log.debug("Failed to delete lock", (Throwable)exception)));
        }
    }

    void sweep(ShardId shardId, String docId, BytesReference jobSource, JobDocVersion jobDocVersion) {
        ConcurrentHashMap<Object, Object> jobVersionMap;
        if (this.sweptJobs.containsKey(shardId)) {
            jobVersionMap = this.sweptJobs.get(shardId);
        } else {
            jobVersionMap = new ConcurrentHashMap();
            this.sweptJobs.put(shardId, jobVersionMap);
        }
        jobVersionMap.compute(docId, (id, currentJobDocVersion) -> {
            if (jobDocVersion.compareTo(currentJobDocVersion) <= 0) {
                log.debug("Skipping job {}, new version {} <= current version {}", (Object)docId, (Object)jobDocVersion, currentJobDocVersion);
                return currentJobDocVersion;
            }
            if (this.scheduler.getScheduledJobIds(shardId.getIndexName()).contains(docId)) {
                this.scheduler.deschedule(shardId.getIndexName(), docId);
            }
            if (jobSource != null) {
                try {
                    ScheduledJobProvider provider = this.indexToProviders.get(shardId.getIndexName());
                    XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)jobSource, (MediaType)MediaTypeRegistry.JSON);
                    ScheduledJobParameter jobParameter = provider.getJobParser().parse(parser, docId, jobDocVersion);
                    if (jobParameter == null) {
                        return null;
                    }
                    ScheduledJobRunner jobRunner = this.indexToProviders.get(shardId.getIndexName()).getJobRunner();
                    if (jobParameter.isEnabled()) {
                        this.scheduler.schedule(shardId.getIndexName(), docId, jobParameter, jobRunner, jobDocVersion, this.jitterLimit);
                    }
                    return jobDocVersion;
                }
                catch (Exception e) {
                    log.warn("Unable to parse job {}, error message: {}", (Object)docId, (Object)e.getMessage());
                    return currentJobDocVersion;
                }
            }
            return null;
        });
    }

    public void clusterChanged(ClusterStateChangedEvent event) {
        for (String indexName : this.indexToProviders.keySet()) {
            if (!event.indexRoutingTableChanged(indexName)) continue;
            this.fullSweepExecutor.submit(() -> this.sweepIndex(indexName));
        }
    }

    void initBackgroundSweep() {
        if (this.scheduledFullSweep != null) {
            this.scheduledFullSweep.cancel();
        }
        Runnable scheduledSweep = () -> {
            log.info("Running full sweep");
            TimeValue elapsedTime = this.getFullSweepElapsedTime();
            long delta = this.sweepPeriod.millis() - elapsedTime.millis();
            if (delta < 20L) {
                this.fullSweepExecutor.submit(this::sweepAllJobIndices);
            }
        };
        this.scheduledFullSweep = this.threadPool.scheduleWithFixedDelay(scheduledSweep, this.sweepPeriod, "same");
    }

    private TimeValue getFullSweepElapsedTime() {
        return TimeValue.timeValueNanos((long)(System.nanoTime() - this.lastFullSweepTimeNano));
    }

    private Map<ShardId, List<ShardRouting>> getLocalShards(ClusterState clusterState, String localNodeId, String indexName) {
        List allShards = clusterState.routingTable().allShards(indexName);
        Map shards = allShards.stream().filter(ShardRouting::active).collect(Collectors.groupingBy(ShardRouting::shardId, Collectors.mapping(shardRouting -> shardRouting, Collectors.toList())));
        return shards.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().filter(shardRouting -> shardRouting.currentNodeId().equals(localNodeId)).count() > 0L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void sweepAllJobIndices() {
        for (String indexName : this.indexToProviders.keySet()) {
            this.sweepIndex(indexName);
        }
        this.lastFullSweepTimeNano = System.nanoTime();
    }

    private void sweepIndex(String indexName) {
        ClusterState clusterState = this.clusterService.state();
        if (!clusterState.routingTable().hasIndex(indexName)) {
            for (ShardId shardId : this.sweptJobs.keySet()) {
                if (!shardId.getIndexName().equals(indexName) || !this.sweptJobs.containsKey(shardId)) continue;
                log.info("Descheduling jobs, shard {} index {} as the index is removed.", (Object)shardId.getId(), (Object)indexName);
                this.scheduler.bulkDeschedule(shardId.getIndexName(), this.sweptJobs.get(shardId).keySet());
            }
            return;
        }
        String localNodeId = clusterState.getNodes().getLocalNodeId();
        Map<ShardId, List<ShardRouting>> localShards = this.getLocalShards(clusterState, localNodeId, indexName);
        Iterator<Map.Entry<ShardId, ConcurrentHashMap<String, JobDocVersion>>> sweptJobIter = this.sweptJobs.entrySet().iterator();
        while (sweptJobIter.hasNext()) {
            Map.Entry<ShardId, ConcurrentHashMap<String, JobDocVersion>> entry = sweptJobIter.next();
            if (!entry.getKey().getIndexName().equals(indexName) || localShards.containsKey(entry.getKey())) continue;
            log.info("Descheduling jobs of shard {} index {} as the shard is removed from this node.", (Object)entry.getKey().getId(), (Object)indexName);
            this.scheduler.bulkDeschedule(indexName, entry.getValue().keySet());
            sweptJobIter.remove();
        }
        for (Map.Entry<ShardId, List<ShardRouting>> shard : localShards.entrySet()) {
            try {
                List<ShardRouting> shardRoutingList = shard.getValue();
                List<String> shardNodeIds = shardRoutingList.stream().map(ShardRouting::currentNodeId).collect(Collectors.toList());
                this.sweepShard(shard.getKey(), new ShardNodes(localNodeId, shardNodeIds), null);
            }
            catch (Exception e) {
                log.info("Error while sweeping shard {}, error message: {}", (Object)shard.getKey(), (Object)e.getMessage());
            }
        }
    }

    private void sweepShard(ShardId shardId, ShardNodes shardNodes, String startAfter) {
        String searchAfter;
        ConcurrentHashMap currentJobs = this.sweptJobs.containsKey(shardId) ? this.sweptJobs.get(shardId) : new ConcurrentHashMap();
        for (String jobId : currentJobs.keySet()) {
            if (shardNodes.isOwningNode(jobId)) continue;
            this.scheduler.deschedule(shardId.getIndexName(), jobId);
            currentJobs.remove(jobId);
        }
        String string = searchAfter = startAfter == null ? "" : startAfter;
        while (searchAfter != null) {
            SearchRequest jobSearchRequest = new SearchRequest().indices(new String[]{shardId.getIndexName()}).preference("_shards:" + shardId.id() + "|_primary").source(new SearchSourceBuilder().version(Boolean.valueOf(true)).seqNoAndPrimaryTerm(Boolean.valueOf(true)).sort((BaseSortBuilder)new FieldSortBuilder("_id").unmappedType("keyword").missing((Object)"_last")).searchAfter((Object[])new String[]{searchAfter}).size(this.sweepPageMaxSize.intValue()).query((QueryBuilder)QueryBuilders.matchAllQuery()));
            SearchResponse response = (SearchResponse)this.retry(searchRequest -> this.client.search(searchRequest), jobSearchRequest, this.sweepSearchBackoff).actionGet(this.sweepSearchTimeout);
            if (response.status() != RestStatus.OK) {
                log.error("Error sweeping shard {}, failed querying jobs on this shard", (Object)shardId);
                return;
            }
            for (SearchHit hit : response.getHits()) {
                String jobId = hit.getId();
                if (!shardNodes.isOwningNode(jobId)) continue;
                this.sweep(shardId, jobId, hit.getSourceRef(), new JobDocVersion(hit.getPrimaryTerm(), hit.getSeqNo(), hit.getVersion()));
            }
            if (response.getHits() == null || response.getHits().getHits().length < 1) {
                searchAfter = null;
                continue;
            }
            SearchHit lastHit = response.getHits().getHits()[response.getHits().getHits().length - 1];
            searchAfter = lastHit.getId();
        }
    }

    private <T, R> R retry(Function<T, R> function, T param, BackoffPolicy backoffPolicy) {
        HashSet retryalbeStatus = Sets.newHashSet((Object[])new RestStatus[]{RestStatus.BAD_GATEWAY, RestStatus.GATEWAY_TIMEOUT, RestStatus.SERVICE_UNAVAILABLE});
        Iterator iter = backoffPolicy.iterator();
        while (true) {
            try {
                return function.apply(param);
            }
            catch (SkyliteException e) {
                if (iter.hasNext() && retryalbeStatus.contains(e.status())) {
                    try {
                        Thread.sleep(((TimeValue)iter.next()).millis());
                    }
                    catch (InterruptedException ex) {
                        throw e;
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private static class ShardNodes {
        private static final int VIRTUAL_NODE_COUNT = 100;
        String localNodeId;
        Collection<String> activeShardNodeIds;
        private TreeMap<Integer, String> circle;

        ShardNodes(String localNodeId, Collection<String> activeShardNodeIds) {
            this.localNodeId = localNodeId;
            this.activeShardNodeIds = activeShardNodeIds;
            this.circle = new TreeMap();
            for (String node : activeShardNodeIds) {
                for (int i = 0; i < 100; ++i) {
                    this.circle.put(Murmur3HashFunction.hash((String)(node + i)), node);
                }
            }
        }

        boolean isOwningNode(String jobId) {
            if (this.circle.isEmpty()) {
                return false;
            }
            int jobHashCode = Murmur3HashFunction.hash((String)jobId);
            String nodeId = this.circle.higherEntry(jobHashCode) == null ? this.circle.firstEntry().getValue() : this.circle.higherEntry(jobHashCode).getValue();
            return this.localNodeId.equals(nodeId);
        }
    }
}

