/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.modality.nlp.qa.QAInput;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonUtils;
import ai.djl.util.PairList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QuestionAnsweringTranslator
implements Translator<QAInput, String> {
    private HuggingFaceTokenizer tokenizer;
    private boolean includeTokenTypes;
    private boolean int32;
    private Batchifier batchifier;
    private boolean detail;

    QuestionAnsweringTranslator(HuggingFaceTokenizer tokenizer, boolean includeTokenTypes, boolean int32, Batchifier batchifier, boolean detail) {
        this.tokenizer = tokenizer;
        this.includeTokenTypes = includeTokenTypes;
        this.int32 = int32;
        this.batchifier = batchifier;
        this.detail = detail;
    }

    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    public NDList processInput(TranslatorContext ctx, QAInput input) {
        Encoding encoding = this.tokenizer.encode(input.getQuestion(), input.getParagraph());
        ctx.setAttachment("encoding", (Object)encoding);
        return encoding.toNDList(ctx.getNDManager(), this.includeTokenTypes, this.int32);
    }

    public NDList batchProcessInput(TranslatorContext ctx, List<QAInput> inputs) {
        NDManager manager = ctx.getNDManager();
        PairList pair = new PairList(inputs.size());
        for (QAInput input : inputs) {
            pair.add((Object)input.getQuestion(), (Object)input.getParagraph());
        }
        Encoding[] encodings = this.tokenizer.batchEncode((PairList<String, String>)pair);
        ctx.setAttachment("encodings", (Object)encodings);
        NDList[] batch = new NDList[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            batch[i] = encodings[i].toNDList(manager, this.includeTokenTypes, this.int32);
        }
        return this.batchifier.batchify(batch);
    }

    public String processOutput(TranslatorContext ctx, NDList list) {
        Encoding encoding = (Encoding)ctx.getAttachment("encoding");
        return this.decode(list, encoding);
    }

    public List<String> batchProcessOutput(TranslatorContext ctx, NDList list) {
        NDList[] batch = this.batchifier.unbatchify(list);
        Encoding[] encodings = (Encoding[])ctx.getAttachment("encodings");
        ArrayList<String> ret = new ArrayList<String>(batch.length);
        for (int i = 0; i < encodings.length; ++i) {
            ret.add(this.decode(batch[i], encodings[i]));
        }
        return ret;
    }

    private String decode(NDList list, Encoding encoding) {
        NDArray startLogits = (NDArray)list.get(0);
        NDArray endLogits = (NDArray)list.get(1);
        if ("PyTorch".equals(startLogits.getManager().getEngine().getEngineName())) {
            startLogits = startLogits.duplicate();
            endLogits = endLogits.duplicate();
        }
        if (this.detail) {
            long[] sequenceIds = encoding.getSequenceIds();
            ArrayList<Integer> undesired = new ArrayList<Integer>();
            for (int i = 0; i < sequenceIds.length; ++i) {
                if (sequenceIds[i] != 0L) continue;
                undesired.add(i);
            }
            int[] idx = undesired.stream().mapToInt(Integer::intValue).toArray();
            NDIndex ndIndex = new NDIndex("{}", new Object[]{list.getManager().create(idx)});
            startLogits.set(ndIndex, (Number)Float.valueOf(-100000.0f));
            endLogits.set(ndIndex, (Number)Float.valueOf(-100000.0f));
            startLogits = startLogits.sub(startLogits.max()).exp();
            startLogits = startLogits.div(startLogits.sum());
            endLogits = endLogits.sub(endLogits.max()).exp();
            endLogits = endLogits.div(endLogits.sum());
        }
        startLogits.set(new NDIndex(new long[]{0L}), (Number)-100000);
        endLogits.set(new NDIndex(new long[]{0L}), (Number)-100000);
        int startIdx = (int)startLogits.argMax().getLong(new long[0]);
        int endIdx = (int)endLogits.argMax().getLong(new long[0]);
        if (startIdx > endIdx) {
            int tmp = startIdx;
            startIdx = endIdx;
            endIdx = tmp;
            NDArray tmpArray = startLogits;
            startLogits = endLogits;
            endLogits = tmpArray;
        }
        long[] indices = encoding.getIds();
        int len = endIdx - startIdx + 1;
        long[] ids = new long[len];
        System.arraycopy(indices, startIdx, ids, 0, len);
        String answer = this.tokenizer.decode(ids).trim();
        if (this.detail) {
            float score = startLogits.getFloat(new long[]{startIdx}) * endLogits.getFloat(new long[]{endIdx});
            ConcurrentHashMap<String, Object> dict = new ConcurrentHashMap<String, Object>();
            dict.put("score", Float.valueOf(score));
            dict.put("start", startIdx);
            dict.put("end", endIdx);
            dict.put("answer", answer);
            return JsonUtils.toJson(dict);
        }
        return answer;
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = QuestionAnsweringTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private boolean includeTokenTypes;
        private boolean int32;
        private Batchifier batchifier = Batchifier.STACK;
        private boolean detail;

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optIncludeTokenTypes(boolean includeTokenTypes) {
            this.includeTokenTypes = includeTokenTypes;
            return this;
        }

        public Builder optInt32(boolean int32) {
            this.int32 = int32;
            return this;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public Builder optDetail(boolean detail) {
            this.detail = detail;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            this.optIncludeTokenTypes(ArgumentsUtil.booleanValue(arguments, (String)"includeTokenTypes"));
            this.optInt32(ArgumentsUtil.booleanValue(arguments, (String)"int32"));
            String batchifierStr = ArgumentsUtil.stringValue(arguments, (String)"batchifier", (String)"stack");
            this.optDetail(ArgumentsUtil.booleanValue(arguments, (String)"detail"));
            this.optBatchifier(Batchifier.fromString((String)batchifierStr));
        }

        public QuestionAnsweringTranslator build() throws IOException {
            return new QuestionAnsweringTranslator(this.tokenizer, this.includeTokenTypes, this.int32, this.batchifier, this.detail);
        }
    }
}

