/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.ParseField;
import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.analysis.NormalizingTokenFilterFactory;
import io.skylite.core.analysis.TokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;

public class ASCIIFoldingTokenFilterFactory
extends AbstractTokenFilterFactory
implements NormalizingTokenFilterFactory {
    public static final ParseField PRESERVE_ORIGINAL = new ParseField("preserve_original", new String[0]);
    public static final boolean DEFAULT_PRESERVE_ORIGINAL = false;
    private final boolean preserveOriginal;

    public ASCIIFoldingTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.preserveOriginal = settings.getAsBoolean(PRESERVE_ORIGINAL.getPreferredName(), Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ASCIIFoldingFilter(tokenStream, this.preserveOriginal);
    }

    public TokenFilterFactory getSynonymFilter() {
        if (!this.preserveOriginal) {
            return this;
        }
        return new TokenFilterFactory(){

            public String name() {
                return ASCIIFoldingTokenFilterFactory.this.name();
            }

            public TokenStream create(TokenStream tokenStream) {
                return new ASCIIFoldingFilter(tokenStream, false);
            }
        };
    }

    public TokenStream normalize(TokenStream tokenStream) {
        return new ASCIIFoldingFilter(tokenStream, false);
    }
}

