/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.analysis.Analysis;
import io.skylite.core.analysis.TokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.commongrams.CommonGramsQueryFilter;

public class CommonGramsTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet words;
    private final boolean ignoreCase;
    private final boolean queryMode;

    CommonGramsTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.ignoreCase = settings.getAsBoolean("ignore_case", Boolean.valueOf(false));
        this.queryMode = settings.getAsBoolean("query_mode", Boolean.valueOf(false));
        this.words = Analysis.parseCommonWords((Environment)env, (Settings)settings, null, (boolean)this.ignoreCase);
        if (this.words == null) {
            throw new IllegalArgumentException("missing or empty [common_words] or [common_words_path] configuration for common_grams token filter");
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        CommonGramsFilter filter = new CommonGramsFilter(tokenStream, this.words);
        if (this.queryMode) {
            return new CommonGramsQueryFilter(filter);
        }
        return filter;
    }

    public TokenFilterFactory getSynonymFilter() {
        throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
    }
}

